/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.mex;

import java.util.List;
import java.util.Map;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.Addressing;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.mex.MEXUtils;
import org.apache.cxf.ws.mex.MetadataExchange;
import org.apache.cxf.ws.mex.model._2004_09.GetMetadata;
import org.apache.cxf.ws.mex.model._2004_09.Metadata;
import org.apache.cxf.ws.mex.model._2004_09.MetadataReference;
import org.apache.cxf.ws.mex.model._2004_09.MetadataSection;
import org.apache.cxf.ws.mex.model._2004_09.ObjectFactory;
import org.w3c.dom.Element;

@SOAPBinding(parameterStyle=SOAPBinding.ParameterStyle.BARE)
@BindingType(value="http://www.w3.org/2003/05/soap/bindings/HTTP/")
@Addressing(required=true, enabled=true)
@XmlSeeAlso(value={ObjectFactory.class})
public class MEXEndpoint
implements MetadataExchange {
    Server server;

    public MEXEndpoint(EndpointImpl server) {
        this((Server)server.getServer());
    }

    public MEXEndpoint(Server server) {
        this.server = server;
    }

    private String getAddressingNamespace() {
        return ((AddressingProperties)PhaseInterceptorChain.getCurrentMessage().get(AddressingProperties.class)).getNamespaceURI();
    }

    @Override
    public Metadata get2004() {
        Map<String, String> map;
        Metadata metadata = new Metadata();
        List<Element> wsdls = MEXUtils.getWSDLs(this.server);
        for (Element element : wsdls) {
            MetadataSection metadataSection = new MetadataSection();
            metadataSection.setAny(element);
            metadataSection.setIdentifier(element.getAttribute("targetNamespace"));
            metadataSection.setDialect("http://schemas.xmlsoap.org/wsdl/");
            metadata.getMetadataSection().add(metadataSection);
        }
        Map<String, String> schemas = MEXUtils.getSchemaLocations(this.server);
        if (schemas != null && !schemas.isEmpty()) {
            for (Map.Entry<String, String> entry : schemas.entrySet()) {
                MetadataSection sect = new MetadataSection();
                sect.setDialect("http://www.w3.org/2001/XMLSchema");
                sect.setIdentifier(entry.getKey());
                sect.setLocation(entry.getValue());
                metadata.getMetadataSection().add(sect);
            }
        }
        if ((map = MEXUtils.getPolicyLocations(this.server)) != null && !map.isEmpty()) {
            for (Map.Entry<String, String> s : map.entrySet()) {
                MetadataSection sect = new MetadataSection();
                sect.setDialect("http://schemas.xmlsoap.org/ws/2004/09/policy");
                sect.setIdentifier(s.getKey());
                MetadataReference ref = new MetadataReference();
                Element el = DOMUtils.getEmptyDocument().createElementNS(this.getAddressingNamespace(), "wsa:Address");
                el.setTextContent(s.getValue());
                ref.getAny().add(el);
                sect.setMetadataReference(ref);
                metadata.getMetadataSection().add(sect);
            }
        }
        return metadata;
    }

    @Override
    public Metadata getMetadata(GetMetadata body) {
        Metadata metadata;
        block6: {
            String id;
            String dialect;
            block7: {
                block5: {
                    dialect = body.getDialect();
                    id = body.getIdentifier();
                    metadata = new Metadata();
                    if (!"http://schemas.xmlsoap.org/wsdl/".equals(dialect)) break block5;
                    List<Element> wsdls = MEXUtils.getWSDLs(this.server);
                    for (Element el : wsdls) {
                        MetadataSection sect = new MetadataSection();
                        sect.setAny(el);
                        sect.setDialect("http://schemas.xmlsoap.org/wsdl/");
                        metadata.getMetadataSection().add(sect);
                    }
                    break block6;
                }
                if (!"http://www.w3.org/2001/XMLSchema".equals(dialect)) break block7;
                List<Element> schemas = MEXUtils.getSchemas(this.server, id);
                for (Element el : schemas) {
                    MetadataSection sect = new MetadataSection();
                    sect.setAny(el);
                    sect.setDialect("http://www.w3.org/2001/XMLSchema");
                    sect.setIdentifier(DOMUtils.getAttributeValueEmptyNull((Element)el, (String)"targetNamespace"));
                    metadata.getMetadataSection().add(sect);
                }
                break block6;
            }
            if (!"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(dialect)) break block6;
            List<Element> policies = MEXUtils.getPolicies(this.server, id);
            for (Element el : policies) {
                MetadataSection sect = new MetadataSection();
                sect.setAny(el);
                sect.setDialect("http://schemas.xmlsoap.org/ws/2004/09/policy");
                if (id == null) {
                    sect.setIdentifier(DOMUtils.getAttributeValueEmptyNull((Element)el, (String)"Name"));
                } else {
                    sect.setIdentifier(id);
                }
                metadata.getMetadataSection().add(sect);
            }
        }
        return metadata;
    }
}

