/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public enum DirectoryGrouping {
    BY_TYPE("by-type"),
    BY_SERVER("by-server");

    private static final Map<String, DirectoryGrouping> MAP;
    private final String localName;

    public static DirectoryGrouping forName(String localName) {
        DirectoryGrouping directoryGrouping = localName != null ? MAP.get(localName.toLowerCase()) : null;
        return directoryGrouping == null ? DirectoryGrouping.valueOf(localName.toUpperCase(Locale.ENGLISH)) : directoryGrouping;
    }

    private DirectoryGrouping(String localName) {
        this.localName = localName;
    }

    public String toString() {
        return this.localName;
    }

    public ModelNode toModelNode() {
        return new ModelNode().set(this.toString());
    }

    public static DirectoryGrouping defaultValue() {
        return BY_SERVER;
    }

    static {
        HashMap<String, DirectoryGrouping> map = new HashMap<String, DirectoryGrouping>();
        for (DirectoryGrouping directoryGrouping : DirectoryGrouping.values()) {
            map.put(directoryGrouping.localName, directoryGrouping);
        }
        MAP = map;
    }
}

