/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3Subsystem70Parser;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.RemoteHttpConnectionDefinition;
import org.jboss.as.ejb3.subsystem.RemotingProfileResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class EJB3Subsystem80Parser
extends EJB3Subsystem70Parser {
    EJB3Subsystem80Parser() {
    }

    @Override
    protected EJB3SubsystemNamespace getExpectedNamespace() {
        return EJB3SubsystemNamespace.EJB3_8_0;
    }

    @Override
    protected void parseRemote(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        PathAddress ejb3RemoteServiceAddress = SUBSYSTEM_PATH.append("service", "remote");
        ModelNode operation = Util.createAddOperation((PathAddress)ejb3RemoteServiceAddress);
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.CONNECTORS, EJB3SubsystemXMLAttribute.THREAD_POOL_NAME);
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLIENT_MAPPINGS_CLUSTER_NAME: {
                    EJB3RemoteResourceDefinition.CLIENT_MAPPINGS_CLUSTER_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case CONNECTORS: {
                    EJB3RemoteResourceDefinition.CONNECTORS.getParser().parseAndSetParameter((AttributeDefinition)EJB3RemoteResourceDefinition.CONNECTORS, value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case THREAD_POOL_NAME: {
                    EJB3RemoteResourceDefinition.THREAD_POOL_NAME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case EXECUTE_IN_WORKER: {
                    EJB3RemoteResourceDefinition.EXECUTE_IN_WORKER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        operations.add(operation);
        HashSet<EJB3SubsystemXMLElement> parsedElements = new HashSet<EJB3SubsystemXMLElement>();
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            EJB3SubsystemXMLElement element = EJB3SubsystemXMLElement.forName(reader.getLocalName());
            switch (element) {
                case CHANNEL_CREATION_OPTIONS: {
                    if (parsedElements.contains((Object)EJB3SubsystemXMLElement.CHANNEL_CREATION_OPTIONS)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    parsedElements.add(EJB3SubsystemXMLElement.CHANNEL_CREATION_OPTIONS);
                    this.parseChannelCreationOptions(reader, ejb3RemoteServiceAddress, operations);
                    continue block11;
                }
                case PROFILES: {
                    this.parseProfiles(reader, operations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    @Override
    protected void parseProfile(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String profileName = null;
        EJBClientContext.Builder builder = new EJBClientContext.Builder();
        ModelNode operation = Util.createAddOperation();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    profileName = value;
                    continue block10;
                }
                case EXCLUDE_LOCAL_RECEIVER: {
                    RemotingProfileResourceDefinition.EXCLUDE_LOCAL_RECEIVER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case LOCAL_RECEIVER_PASS_BY_VALUE: {
                    RemotingProfileResourceDefinition.LOCAL_RECEIVER_PASS_BY_VALUE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (profileName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(EJB3SubsystemXMLAttribute.NAME.getLocalName()));
        }
        PathAddress address = SUBSYSTEM_PATH.append("remoting-profile", profileName);
        operation.get("address").set(address.toModelNode());
        operations.add(operation);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case STATIC_EJB_DISCOVERY: {
                    ModelNode staticEjb = this.parseStaticEjbDiscoveryType(reader);
                    operation.get("static-ejb-discovery").set(staticEjb);
                    continue block11;
                }
                case REMOTING_EJB_RECEIVER: {
                    this.parseRemotingReceiver(reader, address, operations);
                    continue block11;
                }
                case REMOTE_HTTP_CONNECTION: {
                    this.parseRemoteHttpConnection(reader, address, operations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseRemoteHttpConnection(XMLExtendedStreamReader reader, PathAddress profileAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<EJB3SubsystemXMLAttribute> required = EnumSet.of(EJB3SubsystemXMLAttribute.URI);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            EJB3SubsystemXMLAttribute attribute = EJB3SubsystemXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case URI: {
                    RemoteHttpConnectionDefinition.URI.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress receiverAddress = profileAddress.append("remote-http-connection", name);
        operation.get("address").set(receiverAddress.toModelNode());
        operations.add(operation);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (EJB3SubsystemXMLElement.forName(reader.getLocalName())) {
                case CHANNEL_CREATION_OPTIONS: {
                    this.parseChannelCreationOptions(reader, receiverAddress, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

