/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.wildfly.clustering.marshalling.protostream.EnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.Marshallable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.spi.ByteBufferOutputStream;
import protostream.com.google.protobuf.CodedOutputStream;

public class DefaultProtoStreamWriter
implements ProtoStreamWriter {
    private final ImmutableSerializationContext context;
    private final CodedOutputStream output;

    public DefaultProtoStreamWriter(ImmutableSerializationContext context, RawProtoStreamWriter writer) {
        this(context, ((RawProtoStreamWriterImpl)writer).getDelegate());
    }

    public DefaultProtoStreamWriter(ImmutableSerializationContext context, CodedOutputStream output) {
        this.context = context;
        this.output = output;
    }

    @Override
    public ImmutableSerializationContext getSerializationContext() {
        return this.context;
    }

    @Override
    public void writeObject(int index, Object value) throws IOException {
        this.output.writeTag(index, 2);
        this.writeObjectNoTag(value);
    }

    @Override
    public void writeObjectNoTag(Object value) throws IOException {
        BaseMarshaller marshaller = this.context.getMarshaller(value.getClass());
        OptionalInt size = marshaller instanceof Marshallable ? ((Marshallable)marshaller).size(this.context, value) : OptionalInt.empty();
        try (ByteBufferOutputStream output = new ByteBufferOutputStream(size);){
            ProtobufUtil.writeTo((ImmutableSerializationContext)this.context, (OutputStream)output, (Object)value);
            ByteBuffer buffer = output.getBuffer();
            int offset = buffer.arrayOffset();
            int length = buffer.limit() - offset;
            this.output.writeUInt32NoTag(length);
            this.output.writeRawBytes(buffer.array(), offset, length);
        }
    }

    @Override
    public <E extends Enum<E>> void writeEnum(int index, E value) throws IOException {
        EnumMarshaller marshaller = (EnumMarshaller)this.context.getMarshaller(value.getDeclaringClass());
        this.output.writeEnum(index, marshaller.encode(value));
    }

    @Override
    public void writeStringNoTag(String value) throws IOException {
        this.output.writeStringNoTag(value);
    }

    @Override
    public void writeBoolNoTag(boolean value) throws IOException {
        this.output.writeBoolNoTag(value);
    }

    @Override
    public void writeSInt32NoTag(int value) throws IOException {
        this.output.writeSInt32NoTag(value);
    }

    @Override
    public void writeSInt64NoTag(long value) throws IOException {
        this.output.writeSInt64NoTag(value);
    }

    @Override
    public void writeFloatNoTag(float value) throws IOException {
        this.output.writeFloatNoTag(value);
    }

    @Override
    public void writeDoubleNoTag(double value) throws IOException {
        this.output.writeDoubleNoTag(value);
    }

    @Override
    public void writeRawByte(byte value) throws IOException {
        this.output.writeRawByte(value);
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void writeTag(int index, int wireType) throws IOException {
        this.output.writeTag(index, wireType);
    }

    public void writeUInt32NoTag(int value) throws IOException {
        this.output.writeUInt32NoTag(value);
    }

    public void writeUInt64NoTag(long value) throws IOException {
        this.output.writeUInt64NoTag(value);
    }

    public void writeString(int index, String value) throws IOException {
        this.output.writeString(index, value);
    }

    public void writeInt32(int index, int value) throws IOException {
        this.output.writeInt32(index, value);
    }

    public void writeFixed32(int index, int value) throws IOException {
        this.output.writeFixed32(index, value);
    }

    public void writeUInt32(int index, int value) throws IOException {
        this.output.writeUInt32(index, value);
    }

    public void writeSFixed32(int index, int value) throws IOException {
        this.output.writeSFixed32(index, value);
    }

    public void writeSInt32(int index, int value) throws IOException {
        this.output.writeSInt32(index, value);
    }

    public void writeInt64(int index, long value) throws IOException {
        this.output.writeInt64(index, value);
    }

    public void writeUInt64(int index, long value) throws IOException {
        this.output.writeUInt64(index, value);
    }

    public void writeFixed64(int index, long value) throws IOException {
        this.output.writeFixed64(index, value);
    }

    public void writeSFixed64(int index, long value) throws IOException {
        this.output.writeSFixed64(index, value);
    }

    public void writeSInt64(int index, long value) throws IOException {
        this.output.writeSInt64(index, value);
    }

    public void writeEnum(int index, int value) throws IOException {
        this.output.writeEnum(index, value);
    }

    public void writeBool(int index, boolean value) throws IOException {
        this.output.writeBool(index, value);
    }

    public void writeDouble(int index, double value) throws IOException {
        this.output.writeDouble(index, value);
    }

    public void writeFloat(int index, float value) throws IOException {
        this.output.writeFloat(index, value);
    }

    public void writeBytes(int index, ByteBuffer value) throws IOException {
        this.output.writeByteBuffer(index, value);
    }

    public void writeBytes(int index, byte[] value) throws IOException {
        this.output.writeByteArray(index, value);
    }

    public void writeBytes(int index, byte[] value, int offset, int length) throws IOException {
        this.output.writeByteArray(index, value, offset, length);
    }

    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        this.output.writeRawBytes(value, offset, length);
    }
}

