/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices.util;

import com.arjuna.webservices.util.InvalidEnumerationException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class Enumerated
implements Serializable {
    private final Object value;

    protected Enumerated(Object value) {
        this.value = value;
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs != null && rhs.getClass() == this.getClass()) {
            Object rhsValue = ((Enumerated)rhs).value;
            return this.value == null ? rhsValue == null : this.value.equals(rhsValue);
        }
        return false;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public Object getKey() {
        return this.value;
    }

    public String toString() {
        return this.value == null ? "<null>" : this.value.toString();
    }

    protected abstract Enumerated resolveEnum(Object var1) throws InvalidEnumerationException;

    protected Object readResolve() throws ObjectStreamException {
        try {
            return this.resolveEnum(this.value);
        }
        catch (InvalidEnumerationException iee) {
            throw new InvalidObjectException(iee.getMessage());
        }
    }

    protected static Map generateMap(Enumerated[] enumerations) {
        HashMap<Object, Enumerated> result;
        int numEnumerations;
        int n = numEnumerations = enumerations == null ? 0 : enumerations.length;
        if (numEnumerations == 0) {
            result = Collections.EMPTY_MAP;
        } else {
            result = new HashMap<Object, Enumerated>();
            for (int count = 0; count < numEnumerations; ++count) {
                Enumerated enumeration = enumerations[count];
                result.put(enumeration.getKey(), enumeration);
            }
        }
        return result;
    }
}

