/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.security.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager2;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager3;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager4;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager5;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class SecurityStoreImpl
implements SecurityStore,
HierarchicalRepositoryChangeListener {
    private static final Logger logger = Logger.getLogger(SecurityStoreImpl.class);
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private final ActiveMQSecurityManager securityManager;
    private final Cache<String, ConcurrentHashSet<SimpleString>> authorizationCache;
    private final Cache<String, Pair<Boolean, Subject>> authenticationCache;
    private boolean securityEnabled;
    private final String managementClusterUser;
    private final String managementClusterPassword;
    private final NotificationService notificationService;

    public SecurityStoreImpl(HierarchicalRepository<Set<Role>> securityRepository, ActiveMQSecurityManager securityManager, long invalidationInterval, boolean securityEnabled, String managementClusterUser, String managementClusterPassword, NotificationService notificationService, long authenticationCacheSize, long authorizationCacheSize) {
        this.securityRepository = securityRepository;
        this.securityManager = securityManager;
        this.securityEnabled = securityEnabled;
        this.managementClusterUser = managementClusterUser;
        this.managementClusterPassword = managementClusterPassword;
        this.notificationService = notificationService;
        this.authenticationCache = CacheBuilder.newBuilder().maximumSize(authenticationCacheSize).expireAfterWrite(invalidationInterval, TimeUnit.MILLISECONDS).build();
        this.authorizationCache = CacheBuilder.newBuilder().maximumSize(authorizationCacheSize).expireAfterWrite(invalidationInterval, TimeUnit.MILLISECONDS).build();
        this.securityRepository.registerListener(this);
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    @Override
    public void stop() {
        this.securityRepository.unRegisterListener(this);
    }

    @Override
    public String authenticate(String user, String password, RemotingConnection connection) throws Exception {
        return this.authenticate(user, password, connection, null);
    }

    @Override
    public String authenticate(String user, String password, RemotingConnection connection, String securityDomain) throws Exception {
        if (this.securityEnabled) {
            if (this.managementClusterUser.equals(user)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Authenticating cluster admin user");
                }
                if (!this.managementClusterPassword.equals(password)) {
                    throw ActiveMQMessageBundle.BUNDLE.unableToValidateClusterUser(user);
                }
                return this.managementClusterUser;
            }
            String validatedUser = null;
            boolean userIsValid = false;
            boolean check = true;
            Pair cacheEntry = (Pair)this.authenticationCache.getIfPresent((Object)this.createAuthenticationCacheKey(user, password, connection));
            if (cacheEntry != null) {
                if (!((Boolean)cacheEntry.getA()).booleanValue()) {
                    check = false;
                } else {
                    check = false;
                    userIsValid = true;
                    validatedUser = SecurityStoreImpl.getUserFromSubject((Subject)cacheEntry.getB());
                }
            }
            if (check) {
                if (this.securityManager instanceof ActiveMQSecurityManager5) {
                    Subject subject = ((ActiveMQSecurityManager5)this.securityManager).authenticate(user, password, connection, securityDomain);
                    this.authenticationCache.put((Object)this.createAuthenticationCacheKey(user, password, connection), (Object)new Pair((Object)(subject != null ? 1 : 0), (Object)subject));
                    validatedUser = SecurityStoreImpl.getUserFromSubject(subject);
                } else if (this.securityManager instanceof ActiveMQSecurityManager4) {
                    validatedUser = ((ActiveMQSecurityManager4)this.securityManager).validateUser(user, password, connection, securityDomain);
                } else if (this.securityManager instanceof ActiveMQSecurityManager3) {
                    validatedUser = ((ActiveMQSecurityManager3)this.securityManager).validateUser(user, password, connection);
                } else {
                    userIsValid = this.securityManager instanceof ActiveMQSecurityManager2 ? ((ActiveMQSecurityManager2)this.securityManager).validateUser(user, password, CertificateUtil.getCertsFromConnection((RemotingConnection)connection)) : this.securityManager.validateUser(user, password);
                }
            }
            if (!userIsValid && validatedUser == null) {
                String certSubjectDN = this.getCertSubjectDN(connection);
                if (this.notificationService != null) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)user));
                    props.putSimpleStringProperty(ManagementHelper.HDR_CERT_SUBJECT_DN, SimpleString.toSimpleString((String)certSubjectDN));
                    props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)(connection == null ? "null" : connection.getRemoteAddress())));
                    Notification notification = new Notification(null, (NotificationType)CoreNotificationType.SECURITY_AUTHENTICATION_VIOLATION, props);
                    this.notificationService.sendNotification(notification);
                }
                ActiveMQSecurityException e = ActiveMQMessageBundle.BUNDLE.unableToValidateUser(connection == null ? "null" : connection.getRemoteAddress(), user, certSubjectDN);
                ActiveMQServerLogger.LOGGER.securityProblemWhileAuthenticating(e.getMessage());
                throw e;
            }
            return validatedUser;
        }
        return null;
    }

    public String getCertSubjectDN(RemotingConnection connection) {
        String certSubjectDN = "unavailable";
        X509Certificate[] certs = CertificateUtil.getCertsFromConnection((RemotingConnection)connection);
        if (certs != null && certs.length > 0 && certs[0] != null) {
            certSubjectDN = certs[0].getSubjectDN().getName();
        }
        return certSubjectDN;
    }

    @Override
    public void check(SimpleString address, CheckType checkType, SecurityAuth session) throws Exception {
        this.check(address, null, checkType, session);
    }

    @Override
    public void check(SimpleString address, SimpleString queue, CheckType checkType, SecurityAuth session) throws Exception {
        if (this.securityEnabled) {
            ConcurrentHashSet set;
            Boolean validated;
            String user;
            SimpleString bareAddress = CompositeAddress.extractAddressName((SimpleString)address);
            SimpleString bareQueue = CompositeAddress.extractQueueName((SimpleString)queue);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("checking access permissions to " + bareAddress));
            }
            if (this.managementClusterUser.equals(user = session.getUsername()) && session.getPassword().equals(this.managementClusterPassword)) {
                return;
            }
            Set<Role> roles = this.securityRepository.getMatch(bareAddress.toString());
            SimpleString fqqn = null;
            if (bareQueue != null && this.securityRepository.containsExactMatch((fqqn = CompositeAddress.toFullyQualified((SimpleString)bareAddress, (SimpleString)bareQueue)).toString())) {
                roles = this.securityRepository.getMatch(fqqn.toString());
            }
            if (this.checkAuthorizationCache(fqqn != null ? fqqn : bareAddress, user, checkType)) {
                return;
            }
            if (this.securityManager instanceof ActiveMQSecurityManager5) {
                Subject subject = this.getSubjectForAuthorization(session, (ActiveMQSecurityManager5)this.securityManager);
                validated = ((ActiveMQSecurityManager5)this.securityManager).authorize(subject, roles, checkType, fqqn != null ? fqqn.toString() : bareAddress.toString());
            } else {
                validated = this.securityManager instanceof ActiveMQSecurityManager4 ? Boolean.valueOf(((ActiveMQSecurityManager4)this.securityManager).validateUserAndRole(user, session.getPassword(), roles, checkType, bareAddress.toString(), session.getRemotingConnection(), session.getSecurityDomain()) != null) : (this.securityManager instanceof ActiveMQSecurityManager3 ? Boolean.valueOf(((ActiveMQSecurityManager3)this.securityManager).validateUserAndRole(user, session.getPassword(), roles, checkType, bareAddress.toString(), session.getRemotingConnection()) != null) : (this.securityManager instanceof ActiveMQSecurityManager2 ? Boolean.valueOf(((ActiveMQSecurityManager2)this.securityManager).validateUserAndRole(user, session.getPassword(), roles, checkType, bareAddress.toString(), session.getRemotingConnection())) : Boolean.valueOf(this.securityManager.validateUserAndRole(user, session.getPassword(), roles, checkType))));
            }
            if (!validated.booleanValue()) {
                if (this.notificationService != null) {
                    TypedProperties props = new TypedProperties();
                    props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, bareAddress);
                    props.putSimpleStringProperty(ManagementHelper.HDR_CHECK_TYPE, new SimpleString(checkType.toString()));
                    props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)user));
                    Notification notification = new Notification(null, (NotificationType)CoreNotificationType.SECURITY_PERMISSION_VIOLATION, props);
                    this.notificationService.sendNotification(notification);
                }
                ActiveMQSecurityException ex = bareQueue == null ? ActiveMQMessageBundle.BUNDLE.userNoPermissions(session.getUsername(), checkType, bareAddress) : ActiveMQMessageBundle.BUNDLE.userNoPermissionsQueue(session.getUsername(), checkType, bareQueue, bareAddress);
                AuditLogger.securityFailure((Exception)ex);
                throw ex;
            }
            String key = this.createAuthorizationCacheKey(user, checkType);
            ConcurrentHashSet act = (ConcurrentHashSet)this.authorizationCache.getIfPresent((Object)key);
            if (act != null) {
                set = act;
            } else {
                set = new ConcurrentHashSet();
                this.authorizationCache.put((Object)key, (Object)set);
            }
            set.add((Object)(fqqn != null ? fqqn : bareAddress));
        }
    }

    @Override
    public void onChange() {
        this.invalidateAuthorizationCache();
    }

    public static String getUserFromSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        String validatedUser = "";
        Set<UserPrincipal> users = subject.getPrincipals(UserPrincipal.class);
        for (UserPrincipal userPrincipal : users) {
            validatedUser = userPrincipal.getName();
        }
        return validatedUser;
    }

    private Subject getSubjectForAuthorization(SecurityAuth auth, ActiveMQSecurityManager5 securityManager) {
        Pair cached = (Pair)this.authenticationCache.getIfPresent((Object)this.createAuthenticationCacheKey(auth.getUsername(), auth.getPassword(), auth.getRemotingConnection()));
        if (cached == null) {
            return securityManager.authenticate(auth.getUsername(), auth.getPassword(), auth.getRemotingConnection(), auth.getSecurityDomain());
        }
        return (Subject)cached.getB();
    }

    public void invalidateAuthorizationCache() {
        this.authorizationCache.invalidateAll();
    }

    public void invalidateAuthenticationCache() {
        this.authenticationCache.invalidateAll();
    }

    public long getAuthenticationCacheSize() {
        return this.authenticationCache.size();
    }

    public long getAuthorizationCacheSize() {
        return this.authorizationCache.size();
    }

    private boolean checkAuthorizationCache(SimpleString dest, String user, CheckType checkType) {
        boolean granted = false;
        ConcurrentHashSet act = (ConcurrentHashSet)this.authorizationCache.getIfPresent((Object)this.createAuthorizationCacheKey(user, checkType));
        if (act != null) {
            granted = act.contains((Object)dest);
        }
        return granted;
    }

    private String createAuthenticationCacheKey(String username, String password, RemotingConnection connection) {
        return username + password + this.getCertSubjectDN(connection);
    }

    private String createAuthorizationCacheKey(String user, CheckType checkType) {
        return user + "." + checkType.name();
    }
}

