/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.session.oob;

import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionMetaData;

public class OOBSessionMetaData<L, B extends Batch>
implements SessionMetaData {
    private final SessionManager<L, B> manager;
    private final String id;

    public OOBSessionMetaData(SessionManager<L, B> manager, String id) {
        this.manager = manager;
        this.id = id;
    }

    @Override
    public boolean isNew() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            boolean bl = session.getMetaData().isNew();
            return bl;
        }
    }

    @Override
    public boolean isExpired() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            boolean bl = session.getMetaData().isExpired();
            return bl;
        }
    }

    @Override
    public Instant getCreationTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Instant instant = session.getMetaData().getCreationTime();
            return instant;
        }
    }

    @Override
    public Instant getLastAccessStartTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Instant instant = session.getMetaData().getLastAccessStartTime();
            return instant;
        }
    }

    @Override
    public Instant getLastAccessEndTime() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Instant instant = session.getMetaData().getLastAccessEndTime();
            return instant;
        }
    }

    @Override
    public Duration getMaxInactiveInterval() {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            ImmutableSession session = this.manager.readSession(this.id);
            if (session == null) {
                throw new IllegalStateException();
            }
            Duration duration = session.getMetaData().getMaxInactiveInterval();
            return duration;
        }
    }

    @Override
    public void setLastAccess(Instant startTime, Instant endTime) {
        throw new IllegalStateException();
    }

    @Override
    public void setMaxInactiveInterval(Duration duration) {
        try (Batch batch = this.manager.getBatcher().createBatch();
             Session<L> session = this.manager.findSession(this.id);){
            if (session == null) {
                throw new IllegalStateException();
            }
            session.getMetaData().setMaxInactiveInterval(duration);
        }
    }
}

