/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.io.IOException;
import java.util.LinkedList;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.server.group.AddressableNode;
import org.wildfly.clustering.server.group.LocalNode;
import org.wildfly.clustering.server.singleton.SingletonElectionCommand;

public class SingletonElectionCommandMarshaller
implements ProtoStreamMarshaller<SingletonElectionCommand> {
    private static final int CANDIDATE_INDEX = 1;
    private static final int LOCAL_CANDIDATE_INDEX = 2;
    private static final int ELECTED_INDEX = 3;

    public SingletonElectionCommand readFrom(ProtoStreamReader reader) throws IOException {
        LinkedList<Node> candidates = new LinkedList<Node>();
        Integer elected = null;
        boolean reading = true;
        block5: while (reading) {
            int tag = reader.readTag();
            switch (WireFormat.getTagFieldNumber((int)tag)) {
                case 1: {
                    candidates.add((Node)reader.readObject(AddressableNode.class));
                    continue block5;
                }
                case 2: {
                    candidates.add((Node)reader.readObject(LocalNode.class));
                    continue block5;
                }
                case 3: {
                    elected = reader.readUInt32();
                    continue block5;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return new SingletonElectionCommand(candidates, elected);
    }

    public void writeTo(ProtoStreamWriter writer, SingletonElectionCommand command) throws IOException {
        for (Node candidate : command.getCandidates()) {
            writer.writeObject(candidate instanceof LocalNode ? 2 : 1, (Object)candidate);
        }
        Integer elected = command.getIndex();
        if (elected != null) {
            writer.writeUInt32(3, elected.intValue());
        }
    }

    public Class<? extends SingletonElectionCommand> getJavaClass() {
        return SingletonElectionCommand.class;
    }
}

