/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.health;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.health.HealthSubsystemDefinition;
import org.wildfly.extension.health.ServerProbe;
import org.wildfly.extension.health.ServerProbesService;

public class HealthContextService
implements Service {
    private static final String CONTEXT_NAME = "health";
    private final Consumer<HealthContextService> consumer;
    private final Supplier<ExtensibleHttpManagement> extensibleHttpManagement;
    private final Supplier<Boolean> securityEnabled;
    private Supplier<ServerProbesService> serverProbesService;
    private HttpHandler overrideableHealthHandler;

    static void install(OperationContext context, final boolean securityEnabled) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(HealthSubsystemDefinition.HEALTH_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName());
        Supplier extensibleHttpManagement = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.http.extensible", ExtensibleHttpManagement.class));
        Consumer consumer = serviceBuilder.provides(new ServiceName[]{HealthSubsystemDefinition.HEALTH_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName()});
        Supplier serverProbesService = serviceBuilder.requires(HealthSubsystemDefinition.SERVER_HEALTH_PROBES_CAPABILITY.getCapabilityServiceName());
        Supplier<Object> securityEnabledSupplier = context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.health.http-context.security-enabled") ? serviceBuilder.requires(ServiceName.parse((String)"org.wildfly.extension.health.http-context.security-enabled")) : new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return securityEnabled;
            }
        };
        serviceBuilder.setInstance((Service)new HealthContextService(extensibleHttpManagement, consumer, (Supplier<Boolean>)securityEnabledSupplier, serverProbesService)).install();
    }

    HealthContextService(Supplier<ExtensibleHttpManagement> extensibleHttpManagement, Consumer<HealthContextService> consumer, Supplier<Boolean> securityEnabled, Supplier<ServerProbesService> serverProbesService) {
        this.extensibleHttpManagement = extensibleHttpManagement;
        this.consumer = consumer;
        this.securityEnabled = securityEnabled;
        this.serverProbesService = serverProbesService;
    }

    public void start(StartContext context) {
        this.extensibleHttpManagement.get().addManagementHandler(CONTEXT_NAME, this.securityEnabled.get().booleanValue(), (HttpHandler)new HealthCheckHandler(this.serverProbesService.get()));
        this.consumer.accept(this);
    }

    public void stop(StopContext context) {
        this.extensibleHttpManagement.get().removeContext(CONTEXT_NAME);
        this.consumer.accept(null);
    }

    public void setOverrideableHealthHandler(HttpHandler handler) {
        this.overrideableHealthHandler = handler;
    }

    private class HealthCheckHandler
    implements HttpHandler {
        public static final String HEALTH = "/health";
        public static final String HEALTH_LIVE = "/health/live";
        public static final String HEALTH_READY = "/health/ready";
        private ServerProbesService serverProbes;

        public HealthCheckHandler(ServerProbesService serverProbesService) {
            this.serverProbes = serverProbesService;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (HealthContextService.this.overrideableHealthHandler != null) {
                HealthContextService.this.overrideableHealthHandler.handleRequest(exchange);
                return;
            }
            String requestPath = exchange.getRequestPath();
            if (!(HEALTH.equals(requestPath) || HEALTH_LIVE.equals(requestPath) || HEALTH_READY.equals(requestPath))) {
                exchange.setStatusCode(404);
                return;
            }
            boolean globalOutcome = true;
            ModelNode response = new ModelNode();
            response.setEmptyList();
            if (HEALTH.equals(requestPath) || HEALTH_READY.equals(requestPath)) {
                for (ServerProbe serverProbe : this.serverProbes.getServerProbes()) {
                    ServerProbe.Outcome outcome = serverProbe.getOutcome();
                    if (!outcome.isSuccess()) {
                        globalOutcome = false;
                    }
                    ModelNode probeOutcome = new ModelNode();
                    probeOutcome.get("name").set(serverProbe.getName());
                    probeOutcome.get("outcome").set(outcome.isSuccess());
                    if (outcome.getData().isDefined()) {
                        probeOutcome.get("data").set(outcome.getData());
                    }
                    response.add(probeOutcome);
                }
            }
            if (HEALTH.equals(requestPath) || HEALTH_LIVE.equals(requestPath)) {
                ModelNode probeOutcome = new ModelNode();
                probeOutcome.get("name").set("live-server");
                probeOutcome.get("outcome").set(true);
                response.add(probeOutcome);
            }
            response.add("outcome", globalOutcome);
            exchange.setStatusCode(globalOutcome ? 200 : 503).getResponseHeaders().add(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(response.toJSONString(true));
        }
    }
}

