/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.infinispan.commons.executors.BlockingResource;
import org.infinispan.executors.LimitedExecutor;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.GLOBAL)
public class BlockingManagerImpl
implements BlockingManager {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    Executor nonBlockingExecutor;
    @Inject
    @ComponentName(value="org.infinispan.executors.blocking")
    Executor blockingExecutor;
    private Scheduler blockingScheduler;
    private Scheduler nonBlockingScheduler;

    @Start
    protected void start() {
        this.blockingScheduler = Schedulers.from((Executor)this.blockingExecutor);
        this.nonBlockingScheduler = Schedulers.from((Executor)this.nonBlockingExecutor);
    }

    @Override
    public CompletionStage<Void> runBlocking(Runnable runnable, Object traceId) {
        return this.runBlockingOperation(runnable, traceId, this.blockingExecutor);
    }

    @Override
    public <E> CompletionStage<Void> subscribeBlockingConsumer(Publisher<E> publisher, Consumer<E> consumer, Object traceId) {
        Flowable valuePublisher = Flowable.fromPublisher(publisher);
        if (!this.isCurrentThreadBlocking()) {
            valuePublisher = valuePublisher.observeOn(this.blockingScheduler);
            if (trace) {
                log.tracef("Subscribing to publisher for %s observing on blocking thread", traceId);
            }
        } else if (trace) {
            log.tracef("Subscribing to publisher for %s observing on invoking blocking thread", traceId);
        }
        if (trace) {
            valuePublisher = valuePublisher.doOnNext(value -> log.tracef("Invoking blocking consumer for %s with value %s", traceId, value));
        }
        return this.continueOnNonBlockingThread(valuePublisher.doOnNext(consumer::accept).ignoreElements().toCompletionStage(null), traceId);
    }

    @Override
    public <T, A, R> CompletionStage<R> subscribeBlockingCollector(Publisher<T> publisher, Collector<? super T, A, R> collector, Object traceId) {
        Flowable valuePublisher = Flowable.fromPublisher(publisher);
        if (!this.isCurrentThreadBlocking()) {
            valuePublisher = valuePublisher.observeOn(this.blockingScheduler);
            if (trace) {
                log.tracef("Subscribing to publisher for %s observing on blocking thread", traceId);
            }
        } else if (trace) {
            log.tracef("Subscribing to publisher for %s observing on invoking blocking thread", traceId);
        }
        if (trace) {
            valuePublisher = valuePublisher.doOnNext(value -> log.tracef("Invoking blocking collector for %s with value %s", traceId, value));
        }
        return this.continueOnNonBlockingThread(Flowable.fromPublisher((Publisher)valuePublisher).collect(collector).toCompletionStage(), traceId);
    }

    private CompletionStage<Void> runBlockingOperation(Runnable runnable, Object traceId, Executor executor) {
        CompletableFuture<Void> stage;
        if (this.isCurrentThreadBlocking()) {
            if (trace) {
                log.tracef("Invoked run on a blocking thread, running %s in same blocking thread", traceId);
            }
            try {
                runnable.run();
                return CompletableFutures.completedNull();
            }
            catch (Throwable t) {
                return CompletableFutures.completedExceptionFuture(t);
            }
        }
        if (trace) {
            log.tracef("Submitting blocking run operation %s to blocking thread", traceId);
            stage = CompletableFuture.runAsync(() -> {
                log.tracef("Running blocking run operation %s", traceId);
                runnable.run();
            }, executor);
        } else {
            stage = CompletableFuture.runAsync(runnable, executor);
        }
        return this.continueOnNonBlockingThread(stage, traceId);
    }

    @Override
    public <V> CompletionStage<V> supplyBlocking(Supplier<V> supplier, Object traceId) {
        return this.supplyBlockingOperation(supplier, traceId, this.blockingExecutor);
    }

    private <V> CompletionStage<V> supplyBlockingOperation(Supplier<V> supplier, Object traceId, Executor executor) {
        CompletableFuture<Object> stage;
        if (this.isCurrentThreadBlocking()) {
            if (trace) {
                log.tracef("Invoked supply on a blocking thread, running %s in same blocking thread", traceId);
            }
            try {
                return CompletableFuture.completedFuture(supplier.get());
            }
            catch (Throwable t) {
                return CompletableFutures.completedExceptionFuture(t);
            }
        }
        if (trace) {
            log.tracef("Submitting blocking supply operation %s to blocking thread", traceId);
            stage = CompletableFuture.supplyAsync(() -> {
                log.tracef("Running blocking supply operation %s", traceId);
                return supplier.get();
            }, executor);
        } else {
            stage = CompletableFuture.supplyAsync(supplier, executor);
        }
        return this.continueOnNonBlockingThread(stage, traceId);
    }

    @Override
    public <I, O> CompletionStage<O> handleBlocking(CompletionStage<? extends I> stage, BiFunction<? super I, Throwable, ? extends O> function, Object traceId) {
        if (this.isCurrentThreadBlocking()) {
            Object value = null;
            Throwable throwable = null;
            try {
                if (trace) {
                    log.tracef("Invoked handle on a blocking thread, joining %s in same blocking thread", traceId);
                }
                value = CompletionStages.join(stage);
            }
            catch (Throwable t) {
                throwable = t;
            }
            return CompletableFuture.completedFuture(function.apply(value, throwable));
        }
        return this.continueOnNonBlockingThread(stage.handleAsync(function, this.blockingExecutor), traceId);
    }

    @Override
    public <I, O> CompletionStage<O> thenApplyBlocking(CompletionStage<? extends I> stage, Function<? super I, ? extends O> function, Object traceId) {
        if (this.isCurrentThreadBlocking()) {
            if (trace) {
                log.tracef("Invoked thenApply on a blocking thread, joining %s in same blocking thread", traceId);
            }
            try {
                I value = CompletionStages.join(stage);
                return CompletableFuture.completedFuture(function.apply(value));
            }
            catch (Throwable t) {
                return CompletableFutures.completedExceptionFuture(t);
            }
        }
        return this.continueOnNonBlockingThread(stage.thenApplyAsync(function, this.blockingExecutor), traceId);
    }

    @Override
    public <V> CompletionStage<V> whenCompleteBlocking(CompletionStage<V> stage, BiConsumer<? super V, ? super Throwable> biConsumer, Object traceId) {
        if (this.isCurrentThreadBlocking()) {
            if (trace) {
                log.tracef("Invoked whenComplete on a blocking thread, joining %s in same blocking thread", traceId);
            }
            Object value = null;
            Throwable throwable = null;
            try {
                value = CompletionStages.join(stage);
            }
            catch (Throwable t) {
                throwable = t;
            }
            try {
                biConsumer.accept(value, throwable);
            }
            catch (Throwable t) {
                if (throwable == null) {
                    return CompletableFutures.completedExceptionFuture(t);
                }
                throwable.addSuppressed(t);
                return CompletableFutures.completedExceptionFuture(throwable);
            }
            return stage.whenComplete(biConsumer);
        }
        return this.continueOnNonBlockingThread(stage.whenCompleteAsync(biConsumer, this.blockingExecutor), traceId);
    }

    @Override
    public <V> CompletionStage<V> continueOnNonBlockingThread(CompletionStage<V> delay, Object traceId) {
        if (CompletionStages.isCompletedSuccessfully(delay)) {
            if (trace) {
                log.tracef("Stage for %s was already completed, returning in same thread", traceId);
            }
            return delay;
        }
        return delay.whenCompleteAsync((v, t) -> {
            if (t != null) {
                if (trace) {
                    log.tracef("Continuing execution of id %s with exception %s", traceId, t.getMessage());
                }
            } else if (trace) {
                log.tracef("Continuing execution of id %s", traceId);
            }
        }, this.nonBlockingExecutor);
    }

    @Override
    public <V> Publisher<V> blockingPublisher(Publisher<V> publisher) {
        return Flowable.defer(() -> {
            if (this.isCurrentThreadBlocking()) {
                return publisher;
            }
            return Flowable.fromPublisher((Publisher)publisher).subscribeOn(this.blockingScheduler).observeOn(this.nonBlockingScheduler);
        });
    }

    @Override
    public BlockingManager.BlockingExecutor limitedBlockingExecutor(String name, int concurrentExecutions) {
        LimitedExecutor limitedExecutor = new LimitedExecutor(name, this.blockingExecutor, concurrentExecutions);
        return new LimitedBlockingExecutor(limitedExecutor);
    }

    private boolean isCurrentThreadBlocking() {
        return Thread.currentThread().getThreadGroup() instanceof BlockingResource;
    }

    private class LimitedBlockingExecutor
    implements BlockingManager.BlockingExecutor {
        private final LimitedExecutor limitedExecutor;

        private LimitedBlockingExecutor(LimitedExecutor limitedExecutor) {
            this.limitedExecutor = limitedExecutor;
        }

        @Override
        public CompletionStage<Void> execute(Runnable runnable, Object traceId) {
            return BlockingManagerImpl.this.runBlockingOperation(runnable, traceId, this.limitedExecutor);
        }

        @Override
        public <V> CompletionStage<V> supply(Supplier<V> supplier, Object traceId) {
            return BlockingManagerImpl.this.supplyBlockingOperation(supplier, traceId, this.limitedExecutor);
        }
    }
}

