/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.internal;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.BeanManagerLookupService;

public class BeanManagerUtil {
    public static BeanManager getBeanManager() {
        return CDI.current().getBeanManager();
    }

    public static <T> T createBeanInstance(Class<T> clazz) {
        return BeanManagerUtil.createBeanInstance(clazz, BeanManagerUtil.getBeanManager());
    }

    public static <T> T createBeanInstance(Class<T> clazz, BeanManager beanManager) {
        BeanManager classBeanManager = BeanManagerUtil.getClassBeanManager(clazz, beanManager);
        Bean bean = classBeanManager.resolve(classBeanManager.getBeans(clazz, new Annotation[0]));
        if (bean == null) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type " + clazz.getName());
        }
        CreationalContext context = classBeanManager.createCreationalContext((Contextual)bean);
        return (T)classBeanManager.getReference(bean, clazz, context);
    }

    private static <T> BeanManager getClassBeanManager(Class<T> clazz, BeanManager beanManager) {
        BeanManagerImpl unwrappedBeanManager = BeanManagerProxy.unwrap((BeanManager)beanManager);
        return BeanManagerLookupService.lookupBeanManager(clazz, (BeanManagerImpl)unwrappedBeanManager);
    }
}

