/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.http;

import java.io.IOException;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.IdentityCredentialCallback;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.mechanism.http.ElytronMessages;
import org.wildfly.security.password.interfaces.ClearPassword;

public abstract class UsernamePasswordAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    protected final CallbackHandler callbackHandler;

    protected UsernamePasswordAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    protected boolean authenticate(String realmName, String username, char[] password) throws HttpAuthenticationException {
        RealmCallback realmCallback = realmName != null ? new RealmCallback("User realm", realmName) : null;
        NameCallback nameCallback = new NameCallback("Remote Authentication Name", username);
        nameCallback.setName(username);
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(password);
        ClearPassword clearPwd = ClearPassword.createRaw("clear", password);
        EvidenceVerifyCallback evidenceVerifyCallback = new EvidenceVerifyCallback(evidence);
        ElytronMessages.httpUserPass.debugf("Username authentication. Realm: [%s], Username: [%s].", (Object)realmName, (Object)username);
        try {
            Callback[] callbacks = realmCallback != null ? new Callback[]{realmCallback, nameCallback, evidenceVerifyCallback} : new Callback[]{nameCallback, evidenceVerifyCallback};
            this.callbackHandler.handle(callbacks);
            if (evidenceVerifyCallback.isVerified()) {
                IdentityCredentialCallback credentialUpdateCallback = new IdentityCredentialCallback(new PasswordCredential(clearPwd), true);
                this.callbackHandler.handle(new Callback[]{credentialUpdateCallback});
                boolean bl = true;
                return bl;
            }
            clearPwd.destroy();
            boolean bl = false;
            return bl;
        }
        catch (DestroyFailedException | UnsupportedCallbackException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new HttpAuthenticationException(e);
        }
        finally {
            evidence.destroy();
        }
    }

    protected boolean authorize(String username) throws HttpAuthenticationException {
        ElytronMessages.httpUserPass.debugf("Username authorization. Username: [%s].", (Object)username);
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(username, username);
        try {
            this.callbackHandler.handle(new Callback[]{authorizeCallback});
            return authorizeCallback.isAuthorized();
        }
        catch (UnsupportedCallbackException e) {
            return false;
        }
        catch (IOException e) {
            throw new HttpAuthenticationException(e);
        }
    }

    protected void succeed() throws IOException, UnsupportedCallbackException {
        this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED});
    }

    protected void fail() throws IOException, UnsupportedCallbackException {
        this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.FAILED});
    }
}

