/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.http.impl.headers.Http2HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.clientconnection.ConnectionListener;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.Map;
import java.util.function.BiConsumer;

class Http2ClientConnection
extends Http2ConnectionBase
implements HttpClientConnection {
    private final ConnectionListener<HttpClientConnection> listener;
    private final HttpClientImpl client;
    private final ClientMetrics metrics;
    private long expirationTimestamp;
    private boolean evicted;

    Http2ClientConnection(ConnectionListener<HttpClientConnection> listener, HttpClientImpl client, EventLoopContext context, VertxHttp2ConnectionHandler connHandler, ClientMetrics metrics) {
        super(context, connHandler);
        this.metrics = metrics;
        this.client = client;
        this.listener = listener;
    }

    @Override
    synchronized boolean onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        boolean goneAway = super.onGoAwaySent(lastStreamId, errorCode, debugData);
        if (goneAway) {
            this.tryEvict();
        }
        return goneAway;
    }

    @Override
    synchronized boolean onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        boolean goneAway = super.onGoAwayReceived(lastStreamId, errorCode, debugData);
        if (goneAway) {
            this.tryEvict();
        }
        return goneAway;
    }

    private void tryEvict() {
        if (!this.evicted) {
            this.evicted = true;
            this.listener.onEvict();
        }
    }

    @Override
    protected void concurrencyChanged(long concurrency) {
        int limit = this.client.getOptions().getHttp2MultiplexingLimit();
        if (limit > 0) {
            concurrency = Math.min(concurrency, (long)limit);
        }
        this.listener.onConcurrencyChange(concurrency);
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.client.metrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void upgradeStream(Object metric, ContextInternal context, Handler<AsyncResult<HttpClientStream>> completionHandler) {
        Future<Object> fut;
        Http2ClientConnection http2ClientConnection = this;
        synchronized (http2ClientConnection) {
            try {
                StreamImpl stream = this.createStream(context);
                stream.init(this.handler.connection().stream(1));
                stream.metric = metric;
                fut = Future.succeededFuture(stream);
            }
            catch (Exception e) {
                fut = Future.failedFuture(e);
            }
        }
        completionHandler.handle(fut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStream(ContextInternal context, Handler<AsyncResult<HttpClientStream>> handler) {
        Future<Object> fut;
        Http2ClientConnection http2ClientConnection = this;
        synchronized (http2ClientConnection) {
            try {
                StreamImpl stream = this.createStream(context);
                fut = Future.succeededFuture(stream);
            }
            catch (Exception e) {
                fut = Future.failedFuture(e);
            }
        }
        context.emit(fut, handler);
    }

    private StreamImpl createStream(ContextInternal context) {
        return new StreamImpl(this, context, false);
    }

    private void recycle() {
        int timeout = this.client.getOptions().getHttp2KeepAliveTimeout();
        long expired = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : 0L;
        this.expirationTimestamp = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : 0L;
        this.listener.onRecycle();
    }

    @Override
    public boolean isValid() {
        return this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp;
    }

    @Override
    protected synchronized void onHeadersRead(int streamId, Http2Headers headers, StreamPriority streamPriority, boolean endOfStream) {
        Stream stream = (Stream)this.stream(streamId);
        if (!stream.stream.isTrailersReceived()) {
            stream.onHeaders(headers, streamPriority);
            if (endOfStream) {
                stream.onEnd();
            }
        } else {
            stream.onEnd(new Http2HeadersAdaptor(headers));
        }
    }

    private void metricsEnd(Stream stream) {
        if (this.metrics != null) {
            this.metrics.responseEnd(stream.metric, stream.bytesRead());
        }
    }

    @Override
    public synchronized void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        Handler pushHandler;
        StreamImpl stream = (StreamImpl)this.stream(streamId);
        if (stream != null && (pushHandler = stream.pushHandler) != null) {
            Http2Stream promisedStream = this.handler.connection().stream(promisedStreamId);
            StreamImpl pushStream = new StreamImpl(this, this.context, true);
            pushStream.init(promisedStream);
            HttpClientPush push = new HttpClientPush(headers, pushStream);
            if (this.metrics != null) {
                Object metric = this.metrics.requestBegin(headers.path().toString(), push);
                pushStream.metric = metric;
                this.metrics.requestEnd(metric, 0L);
            }
            stream.context.dispatch(push, pushHandler);
            return;
        }
        this.handler.writeReset(promisedStreamId, Http2Error.CANCEL.code());
    }

    @Override
    protected void handleIdle() {
        if (this.handler.connection().local().numActiveStreams() > 0) {
            super.handleIdle();
        }
    }

    public static VertxHttp2ConnectionHandler<Http2ClientConnection> createHttp2ConnectionHandler(HttpClientImpl client, ClientMetrics metrics, ConnectionListener<HttpClientConnection> listener, EventLoopContext context, Object socketMetric, BiConsumer<Http2ClientConnection, Long> c) {
        long http2MaxConcurrency = client.getOptions().getHttp2MultiplexingLimit() <= 0 ? Long.MAX_VALUE : (long)client.getOptions().getHttp2MultiplexingLimit();
        HttpClientOptions options = client.getOptions();
        Http2ConnectionHandler handler = new VertxHttp2ConnectionHandlerBuilder().server(false).useCompression(client.getOptions().isTryUseCompression()).gracefulShutdownTimeoutMillis(0L).initialSettings(client.getOptions().getInitialSettings()).connectionFactory(connHandler -> new Http2ClientConnection(listener, client, context, (VertxHttp2ConnectionHandler)((Object)connHandler), metrics)).logEnabled(options.getLogActivity()).build();
        HttpClientMetrics met = client.metrics();
        handler.addHandler(conn -> {
            if (options.getHttp2ConnectionWindowSize() > 0) {
                conn.setWindowSize(options.getHttp2ConnectionWindowSize());
            }
            if (metrics != null) {
                Object m = socketMetric;
                if (m == null) {
                    m = met.connected(conn.remoteAddress(), conn.remoteName());
                    met.endpointConnected(metrics);
                }
                conn.metric(m);
            }
            long concurrency = conn.remoteSettings().getMaxConcurrentStreams();
            if (http2MaxConcurrency > 0L) {
                concurrency = Math.min(concurrency, http2MaxConcurrency);
            }
            c.accept((Http2ClientConnection)conn, concurrency);
        });
        handler.removeHandler(conn -> {
            if (metrics != null) {
                met.endpointDisconnected(metrics);
            }
            conn.tryEvict();
        });
        return handler;
    }

    static class StreamImpl
    extends Stream
    implements HttpClientStream {
        StreamImpl(Http2ClientConnection conn, ContextInternal context, boolean push) {
            super(conn, context, push);
        }

        @Override
        public void continueHandler(Handler<Void> handler) {
            this.continueHandler = handler;
        }

        @Override
        public void unknownFrameHandler(Handler<HttpFrame> handler) {
            this.unknownFrameHandler = handler;
        }

        @Override
        public void pushHandler(Handler<HttpClientPush> handler) {
            this.pushHandler = handler;
        }

        @Override
        public void drainHandler(Handler<Void> handler) {
            this.drainHandler = handler;
        }

        @Override
        public void exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
        }

        @Override
        public void headHandler(Handler<HttpResponseHead> handler) {
            this.headHandler = handler;
        }

        @Override
        public void chunkHandler(Handler<Buffer> handler) {
            this.chunkHandler = handler;
        }

        @Override
        public void priorityHandler(Handler<StreamPriority> handler) {
            this.priorityHandler = handler;
        }

        @Override
        public void endHandler(Handler<MultiMap> handler) {
            this.endHandler = handler;
        }

        @Override
        public StreamPriority priority() {
            return super.priority();
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
            super.updatePriority(streamPriority);
        }

        @Override
        public HttpVersion version() {
            return HttpVersion.HTTP_2;
        }

        @Override
        void handleEnd(MultiMap trailers) {
            if (this.endHandler != null) {
                this.endHandler.handle(trailers);
            }
        }

        @Override
        void handleData(Buffer buf) {
            if (this.chunkHandler != null) {
                this.chunkHandler.handle(buf);
            }
        }

        @Override
        void handleReset(long errorCode) {
            this.handleException(new StreamResetException(errorCode));
        }

        @Override
        void handleWritabilityChanged(boolean writable) {
            if (writable && this.drainHandler != null) {
                this.drainHandler.handle(null);
            }
        }

        @Override
        void handleCustomFrame(HttpFrame frame) {
            if (this.unknownFrameHandler != null) {
                this.unknownFrameHandler.handle(frame);
            }
        }

        @Override
        void handlePriorityChange(StreamPriority streamPriority) {
            if (this.priorityHandler != null) {
                this.priorityHandler.handle(streamPriority);
            }
        }

        @Override
        void handleContinue() {
            if (this.continueHandler != null) {
                this.continueHandler.handle(null);
            }
        }

        @Override
        void handleException(Throwable exception) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(exception);
            }
        }

        @Override
        public void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect, Handler<AsyncResult<Void>> handler) {
            this.priority(priority);
            ((Http2ClientConnection)this.conn).context.emit(null, v -> this.writeHeaders(request, buf, end, priority, connect, handler));
        }

        private void writeHeaders(HttpRequestHead request, ByteBuf buf, boolean end, StreamPriority priority, boolean connect, Handler<AsyncResult<Void>> handler) {
            boolean e;
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            headers.method((CharSequence)request.method.name());
            if (request.method == HttpMethod.CONNECT) {
                if (request.authority == null) {
                    throw new IllegalArgumentException("Missing :authority / host header");
                }
                headers.authority((CharSequence)request.authority);
                e = false;
            } else {
                headers.path((CharSequence)request.uri);
                headers.scheme((CharSequence)(((Http2ClientConnection)this.conn).isSsl() ? "https" : "http"));
                if (request.authority != null) {
                    headers.authority((CharSequence)request.authority);
                }
                e = end;
            }
            if (request.headers != null && request.headers.size() > 0) {
                for (Map.Entry header : request.headers) {
                    headers.add((Object)HttpUtils.toLowerCase((CharSequence)header.getKey()), header.getValue());
                }
            }
            if (((Http2ClientConnection)this.conn).client.getOptions().isTryUseCompression() && headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) == null) {
                headers.set((Object)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
            }
            try {
                this.createStream(request, (Http2Headers)headers, handler);
            }
            catch (Http2Exception ex) {
                if (handler != null) {
                    handler.handle(this.context.failedFuture(ex));
                }
                this.handleException(ex);
                return;
            }
            if (buf != null) {
                this.doWriteHeaders((Http2Headers)headers, false, null);
                this.doWriteData(buf, e, handler);
            } else {
                this.doWriteHeaders((Http2Headers)headers, e, handler);
            }
        }

        private void createStream(HttpRequestHead head, Http2Headers headers, Handler<AsyncResult<Void>> handler) throws Http2Exception {
            VertxTracer tracer;
            int id = ((Http2ClientConnection)this.conn).handler.encoder().connection().local().lastStreamCreated();
            id = id == 0 ? 1 : (id += 2);
            head.id = id;
            head.remoteAddress = ((Http2ClientConnection)this.conn).remoteAddress();
            Http2Stream stream = ((Http2ClientConnection)this.conn).handler.encoder().connection().local().createStream(id, false);
            this.init(stream);
            if (((Http2ClientConnection)this.conn).metrics != null) {
                this.metric = ((Http2ClientConnection)this.conn).metrics.requestBegin(headers.path().toString(), head);
            }
            if ((tracer = this.context.tracer()) != null) {
                BiConsumer<String, String> headers_ = (arg_0, arg_1) -> ((Http2Headers)headers).add(arg_0, arg_1);
                this.trace = tracer.sendRequest(this.context, SpanKind.RPC, ((Http2ClientConnection)this.conn).client.getOptions().getTracingPolicy(), head, headers.method().toString(), headers_, HttpUtils.CLIENT_HTTP_REQUEST_TAG_EXTRACTOR);
            }
        }

        @Override
        public void writeBuffer(ByteBuf buf, boolean end, Handler<AsyncResult<Void>> listener) {
            this.writeData(buf, end, listener);
        }

        @Override
        public ContextInternal getContext() {
            return this.context;
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
        }

        @Override
        public void reset(Throwable cause) {
            long code = cause instanceof StreamResetException ? ((StreamResetException)cause).getCode() : 0L;
            ((Http2ClientConnection)this.conn).context.emit(code, this::writeReset);
        }

        @Override
        public HttpClientConnection connection() {
            return (HttpClientConnection)((Object)this.conn);
        }
    }

    static abstract class Stream
    extends VertxHttp2Stream<Http2ClientConnection> {
        private final boolean push;
        private HttpResponseHead response;
        protected Object metric;
        protected Object trace;
        private boolean requestEnded;
        private boolean responseEnded;
        protected Handler<HttpResponseHead> headHandler;
        protected Handler<Buffer> chunkHandler;
        protected Handler<MultiMap> endHandler;
        protected Handler<StreamPriority> priorityHandler;
        protected Handler<Void> drainHandler;
        protected Handler<Void> continueHandler;
        protected Handler<HttpFrame> unknownFrameHandler;
        protected Handler<Throwable> exceptionHandler;
        protected Handler<HttpClientPush> pushHandler;

        Stream(Http2ClientConnection conn, ContextInternal context, boolean push) {
            super(conn, context);
            this.push = push;
        }

        void onContinue() {
            this.context.emit(null, v -> this.handleContinue());
        }

        abstract void handleContinue();

        public Object metric() {
            return this.metric;
        }

        @Override
        void doWriteData(ByteBuf chunk, boolean end, Handler<AsyncResult<Void>> handler) {
            super.doWriteData(chunk, end, handler);
            if (end) {
                this.endRequest();
            }
        }

        @Override
        void doWriteHeaders(Http2Headers headers, boolean end, Handler<AsyncResult<Void>> handler) {
            this.isConnect = "CONNECT".contentEquals(headers.method());
            super.doWriteHeaders(headers, end, handler);
            if (end) {
                this.endRequest();
            }
        }

        protected void endRequest() {
            this.requestEnded = true;
            if (((Http2ClientConnection)this.conn).metrics != null) {
                ((Http2ClientConnection)this.conn).metrics.requestEnd(this.metric, this.bytesWritten());
            }
        }

        @Override
        void onEnd(MultiMap trailers) {
            ((Http2ClientConnection)this.conn).metricsEnd(this);
            this.responseEnded = true;
            super.onEnd(trailers);
        }

        @Override
        void onReset(long code) {
            if (((Http2ClientConnection)this.conn).metrics != null) {
                ((Http2ClientConnection)this.conn).metrics.requestReset(this.metric);
            }
            super.onReset(code);
        }

        @Override
        void onHeaders(Http2Headers headers, StreamPriority streamPriority) {
            if (streamPriority != null) {
                this.priority(streamPriority);
            }
            if (this.response == null) {
                String statusMessage;
                int status;
                try {
                    status = Integer.parseInt(headers.status().toString());
                    statusMessage = HttpResponseStatus.valueOf((int)status).reasonPhrase();
                }
                catch (Exception e) {
                    this.handleException(e);
                    this.writeReset(1L);
                    return;
                }
                if (status == 100) {
                    this.onContinue();
                    return;
                }
                this.response = new HttpResponseHead(HttpVersion.HTTP_2, status, statusMessage, new Http2HeadersAdaptor(headers));
                headers.remove((Object)":status");
                if (((Http2ClientConnection)this.conn).metrics != null) {
                    ((Http2ClientConnection)this.conn).metrics.responseBegin(this.metric, this.response);
                }
                if (this.headHandler != null) {
                    this.context.emit(this.response, this.headHandler);
                }
            }
        }

        @Override
        void onClose() {
            VertxTracer tracer;
            if (!(((Http2ClientConnection)this.conn).metrics == null || this.requestEnded && this.responseEnded)) {
                ((Http2ClientConnection)this.conn).metrics.requestReset(this.metric);
            }
            if ((tracer = this.context.tracer()) != null && this.trace != null) {
                VertxException err = this.responseEnded && this.requestEnded ? null : ConnectionBase.CLOSED_EXCEPTION;
                tracer.receiveResponse(this.context, this.response, this.trace, err, HttpUtils.CLIENT_RESPONSE_TAG_EXTRACTOR);
            }
            if (!this.responseEnded) {
                this.onError(ConnectionBase.CLOSED_EXCEPTION);
            }
            super.onClose();
            if (!this.push) {
                ((Http2ClientConnection)this.conn).recycle();
            }
        }
    }
}

