/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.constants.OpenApiConstants;
import io.smallrye.openapi.api.constants.SecurityConstants;
import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.media.ContentImpl;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.parameters.RequestBodyImpl;
import io.smallrye.openapi.api.models.responses.APIResponseImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.callback.CallbackReader;
import io.smallrye.openapi.runtime.io.definition.DefinitionReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.operation.OperationReader;
import io.smallrye.openapi.runtime.io.requestbody.RequestBodyReader;
import io.smallrye.openapi.runtime.io.response.ResponseReader;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.io.securityrequirement.SecurityRequirementReader;
import io.smallrye.openapi.runtime.io.securityscheme.SecuritySchemeReader;
import io.smallrye.openapi.runtime.io.server.ServerReader;
import io.smallrye.openapi.runtime.io.tag.TagConstant;
import io.smallrye.openapi.runtime.io.tag.TagReader;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.processor.JavaSecurityProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public interface AnnotationScanner {
    public String getName();

    public OpenAPI scan(AnnotationScannerContext var1, OpenAPI var2);

    public boolean isAsyncResponse(MethodInfo var1);

    public boolean isPostMethod(MethodInfo var1);

    public boolean isDeleteMethod(MethodInfo var1);

    public boolean containsScannerAnnotations(List<AnnotationInstance> var1, List<AnnotationScannerExtension> var2);

    public void setContextRoot(String var1);

    default public boolean isMultipartOutput(Type returnType) {
        return false;
    }

    default public boolean isMultipartInput(Type inputType) {
        return false;
    }

    default public boolean isScannerInternalResponse(Type returnType) {
        return false;
    }

    default public boolean isScannerInternalParameter(Type parameterType) {
        return false;
    }

    default public boolean isWrapperType(Type type) {
        return false;
    }

    default public Type unwrapType(Type type) {
        if (this.isWrapperType(type)) {
            return (Type)type.asParameterizedType().arguments().get(0);
        }
        return null;
    }

    default public void processDefinitionAnnotation(AnnotationScannerContext context, ClassInfo targetClass, OpenAPI openApi) {
        AnnotationInstance openApiDefAnno = DefinitionReader.getDefinitionAnnotation(targetClass);
        if (openApiDefAnno != null) {
            DefinitionReader.processDefinition(context, openApi, openApiDefAnno);
        }
    }

    default public void processSecuritySchemeAnnotation(AnnotationScannerContext context, ClassInfo targetClass, OpenAPI openApi) {
        List<AnnotationInstance> securitySchemeAnnotations = SecuritySchemeReader.getSecuritySchemeAnnotations((AnnotationTarget)targetClass);
        for (AnnotationInstance annotation : securitySchemeAnnotations) {
            String name = SecuritySchemeReader.getSecuritySchemeName(annotation);
            if (name == null && JandexUtil.isRef(annotation)) {
                name = JandexUtil.nameFromRef(annotation);
            }
            if (name == null) continue;
            SecurityScheme securityScheme = SecuritySchemeReader.readSecurityScheme(context, annotation);
            Components components = ModelUtil.components(openApi);
            components.addSecurityScheme(name, securityScheme);
        }
    }

    default public void processServerAnnotation(ClassInfo targetClass, OpenAPI openApi) {
        List<AnnotationInstance> serverAnnotations = ServerReader.getServerAnnotations((AnnotationTarget)targetClass);
        for (AnnotationInstance annotation : serverAnnotations) {
            Server server = ServerReader.readServer(annotation);
            openApi.addServer(server);
        }
    }

    default public void processJavaSecurity(ClassInfo resourceClass, OpenAPI openApi) {
        JavaSecurityProcessor.register(openApi);
        JavaSecurityProcessor.addDeclaredRolesToScopes((String[])TypeUtil.getAnnotationValue((AnnotationTarget)resourceClass, SecurityConstants.DECLARE_ROLES));
        JavaSecurityProcessor.addRolesAllowedToScopes((String[])TypeUtil.getAnnotationValue((AnnotationTarget)resourceClass, SecurityConstants.ROLES_ALLOWED));
    }

    default public void processOperationTags(AnnotationScannerContext context, MethodInfo method, OpenAPI openApi, Set<String> resourceTags, Operation operation) {
        Set<String> tags = this.processTags(context, (AnnotationTarget)method, openApi, true);
        if (tags == null) {
            if (!resourceTags.isEmpty()) {
                operation.setTags(new ArrayList<String>(resourceTags));
            }
        } else if (!tags.isEmpty()) {
            operation.setTags(new ArrayList<String>(tags));
        }
    }

    default public Set<String> processTags(AnnotationScannerContext context, AnnotationTarget target, OpenAPI openApi, boolean nullWhenMissing) {
        if (!TagReader.hasTagAnnotation(target)) {
            return nullWhenMissing ? null : Collections.emptySet();
        }
        LinkedHashSet<String> tags = new LinkedHashSet<String>();
        List<AnnotationInstance> tagAnnos = TagReader.getTagAnnotations(target);
        for (AnnotationInstance ta : tagAnnos) {
            if (JandexUtil.isRef(ta)) {
                tags.add((String)JandexUtil.value(ta, "ref"));
                continue;
            }
            Tag tag = TagReader.readTag(context, ta);
            if (tag.getName() == null) continue;
            ModelUtil.addTag(openApi, tag);
            tags.add(tag.getName());
        }
        String[] refs = (String[])TypeUtil.getAnnotationValue(target, TagConstant.DOTNAME_TAGS, "refs");
        if (refs != null) {
            Arrays.stream(refs).forEach(tags::add);
        }
        return tags;
    }

    default public List<MethodInfo> getResourceMethods(AnnotationScannerContext context, ClassInfo resource) {
        Type resourceType = Type.create((DotName)resource.name(), (Type.Kind)Type.Kind.CLASS);
        Map<ClassInfo, Type> chain = JandexUtil.inheritanceChain(context.getIndex(), resource, resourceType);
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (ClassInfo classInfo : chain.keySet()) {
            methods.addAll(classInfo.methods());
            classInfo.interfaceTypes().stream().map(iface -> context.getIndex().getClassByName(TypeUtil.getName(iface))).filter(Objects::nonNull).flatMap(iface -> iface.methods().stream()).forEach(methods::add);
        }
        return methods;
    }

    default public Optional<Operation> processOperation(AnnotationScannerContext context, MethodInfo method) {
        if (OperationReader.operationIsHidden(method)) {
            return Optional.empty();
        }
        AnnotationInstance operationAnnotation = OperationReader.getOperationAnnotation(method);
        Operation operation = OperationReader.readOperation(context, operationAnnotation, method);
        if (operation == null) {
            operation = new OperationImpl();
        }
        return Optional.of(operation);
    }

    default public void processResponse(AnnotationScannerContext context, MethodInfo method, Operation operation, Map<DotName, AnnotationInstance> exceptionAnnotationMap) {
        List<AnnotationInstance> apiResponseAnnotations = ResponseReader.getResponseAnnotations((AnnotationTarget)method);
        for (AnnotationInstance annotation : apiResponseAnnotations) {
            this.addApiReponseFromAnnotation(context, annotation, operation);
        }
        AnnotationInstance responseSchemaAnnotation = ResponseReader.getResponseSchemaAnnotation(method);
        this.addApiReponseSchemaFromAnnotation(context, responseSchemaAnnotation, method, operation);
        AnnotationInstance apiResponses = ResponseReader.getResponsesAnnotation(method);
        if (apiResponses == null || !JandexUtil.isEmpty(apiResponses)) {
            this.createResponseFromRestMethod(context, method, operation);
        }
        List methodExceptions = method.exceptions();
        for (Type type : methodExceptions) {
            AnnotationInstance exMapperApiResponseAnnotation;
            DotName exceptionDotName = type.name();
            if (exceptionAnnotationMap == null || exceptionAnnotationMap.isEmpty() || !exceptionAnnotationMap.keySet().contains(exceptionDotName) || this.responseCodeExistInMethodAnnotations(context, exMapperApiResponseAnnotation = exceptionAnnotationMap.get(exceptionDotName), apiResponseAnnotations)) continue;
            this.addApiReponseFromAnnotation(context, exMapperApiResponseAnnotation, operation);
        }
    }

    default public void createResponseFromRestMethod(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        Type returnType = context.getResourceTypeResolver().resolve(method.returnType());
        APIResponse response = null;
        int status = this.getDefaultStatus(method);
        String code = String.valueOf(status);
        String description = this.getReasonPhrase(status);
        if (this.isVoidResponse(method)) {
            if (this.generateResponse(code, operation)) {
                response = new APIResponseImpl().description(description);
            }
        } else if (this.generateResponse(code, operation)) {
            response = new APIResponseImpl().description(description);
            if (!(this.isScannerInternalResponse(returnType) || ModelUtil.responses(operation).getAPIResponse(code) != null && ModelUtil.responses(operation).getAPIResponse(code).getContent() != null)) {
                SchemaImpl schema;
                if (this.isMultipartOutput(returnType)) {
                    schema = new SchemaImpl();
                    schema.setType(Schema.SchemaType.OBJECT);
                } else {
                    schema = SchemaFactory.typeToSchema(context, returnType, context.getExtensions());
                }
                ContentImpl content = new ContentImpl();
                String[] produces = CurrentScannerInfo.getCurrentProduces();
                if (produces == null || produces.length == 0) {
                    produces = context.getConfig().getDefaultProduces().orElse(OpenApiConstants.DEFAULT_MEDIA_TYPES.get());
                }
                if (schema != null && schema.getNullable() == null && TypeUtil.isOptional(returnType)) {
                    schema.setNullable(Boolean.TRUE);
                }
                for (String producesType : produces) {
                    MediaTypeImpl mt = new MediaTypeImpl();
                    mt.setSchema(schema);
                    content.addMediaType(producesType, mt);
                }
                response.setContent((Content)content);
            }
        }
        if (response != null) {
            APIResponses responses = ModelUtil.responses(operation);
            if (responses.hasAPIResponse(code)) {
                APIResponse responseFromAnnotations = responses.getAPIResponse(code);
                response = MergeUtil.mergeObjects(response, responseFromAnnotations);
            }
            responses.addAPIResponse(code, response);
        }
    }

    default public int getDefaultStatus(MethodInfo method) {
        int status = this.isVoidResponse(method) ? (this.isPostMethod(method) ? 201 : (!this.isAsyncResponse(method) ? 204 : 200)) : 200;
        return status;
    }

    default public boolean isVoidResponse(MethodInfo method) {
        if (method.returnType().kind().equals((Object)Type.Kind.VOID)) {
            return true;
        }
        if (this.isWrapperType(method.returnType())) {
            ParameterizedType parameterizedType = method.returnType().asParameterizedType();
            List arguments = parameterizedType.arguments();
            for (Type argument : arguments) {
                if (!argument.kind().equals((Object)Type.Kind.VOID) && (!argument.kind().equals((Object)Type.Kind.CLASS) || !argument.name().equals((Object)DotName.createSimple((String)Void.class.getName())))) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean generateResponse(String status, Operation operation) {
        APIResponses responses = operation.getResponses();
        return responses == null || responses.getAPIResponse(status) != null;
    }

    default public void addApiReponseFromAnnotation(AnnotationScannerContext context, AnnotationInstance apiResponseAnnotation, Operation operation) {
        String responseCode = ResponseReader.getResponseName(context, apiResponseAnnotation);
        if (responseCode == null) {
            responseCode = "default";
        }
        APIResponse response = ResponseReader.readResponse(context, apiResponseAnnotation);
        APIResponses responses = ModelUtil.responses(operation);
        responses.addAPIResponse(responseCode, response);
    }

    default public void addApiReponseSchemaFromAnnotation(AnnotationScannerContext context, AnnotationInstance annotation, MethodInfo method, Operation operation) {
        int status;
        if (annotation == null) {
            return;
        }
        String responseCode = ResponseReader.getResponseName(context, annotation);
        if (responseCode != null && responseCode.matches("\\d{3}")) {
            status = Integer.parseInt(responseCode);
        } else {
            status = this.getDefaultStatus(method);
            responseCode = String.valueOf(status);
        }
        APIResponse response = ResponseReader.readResponseSchema(context, annotation);
        if (response.getDescription() == null) {
            response.setDescription(this.getReasonPhrase(status));
        }
        APIResponses responses = ModelUtil.responses(operation);
        responses.addAPIResponse(responseCode, response);
    }

    default public boolean responseCodeExistInMethodAnnotations(AnnotationScannerContext context, AnnotationInstance exMapperApiResponseAnnotation, List<AnnotationInstance> methodApiResponseAnnotations) {
        String exMapperResponseCode = ResponseReader.getResponseName(context, exMapperApiResponseAnnotation);
        return methodApiResponseAnnotations.stream().map(a -> ResponseReader.getResponseName(context, a)).filter(Objects::nonNull).anyMatch(code -> code.equals(exMapperResponseCode));
    }

    default public void processSecurityRequirementAnnotation(ClassInfo resourceClass, MethodInfo method, Operation operation) {
        if (this.isEmptySecurityRequirements((AnnotationTarget)method)) {
            operation.setSecurity(new ArrayList(0));
        } else {
            List<AnnotationInstance> requirements = SecurityRequirementReader.getSecurityRequirementAnnotations((AnnotationTarget)method);
            if (requirements.isEmpty()) {
                if (this.isEmptySecurityRequirements((AnnotationTarget)resourceClass)) {
                    operation.setSecurity(new ArrayList(0));
                } else {
                    requirements = SecurityRequirementReader.getSecurityRequirementAnnotations((AnnotationTarget)resourceClass);
                }
            }
            for (AnnotationInstance annotation : requirements) {
                SecurityRequirement requirement = SecurityRequirementReader.readSecurityRequirement(annotation);
                if (requirement == null) continue;
                operation.addSecurityRequirement(requirement);
            }
        }
    }

    default public boolean isEmptySecurityRequirements(AnnotationTarget target) {
        AnnotationInstance[] values;
        AnnotationInstance securityRequirements = SecurityRequirementReader.getSecurityRequirementsAnnotation(target);
        return securityRequirements != null && ((values = (AnnotationInstance[])JandexUtil.value(securityRequirements, "value")) == null || values.length == 0);
    }

    default public void processCallback(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        List<AnnotationInstance> callbackAnnotations = CallbackReader.getCallbackAnnotations((AnnotationTarget)method);
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        for (AnnotationInstance annotation : callbackAnnotations) {
            String name = CallbackReader.getCallbackName(annotation);
            if (name == null && JandexUtil.isRef(annotation)) {
                name = JandexUtil.nameFromRef(annotation);
            }
            if (name != null) {
                callbacks.put(name, CallbackReader.readCallback(context, annotation));
            }
            if (callbacks.isEmpty()) continue;
            operation.setCallbacks(callbacks);
        }
    }

    default public void processServerAnnotation(MethodInfo method, Operation operation) {
        List<AnnotationInstance> serverAnnotations = ServerReader.getServerAnnotations((AnnotationTarget)method);
        if (serverAnnotations.isEmpty()) {
            serverAnnotations.addAll(ServerReader.getServerAnnotations((AnnotationTarget)method.declaringClass()));
        }
        for (AnnotationInstance annotation : serverAnnotations) {
            Server server = ServerReader.readServer(annotation);
            operation.addServer(server);
        }
    }

    default public void processExtensions(AnnotationScannerContext context, MethodInfo method, Operation operation) {
        List<AnnotationInstance> extensionAnnotations = ExtensionReader.getExtensionsAnnotations((AnnotationTarget)method);
        if (extensionAnnotations.isEmpty()) {
            extensionAnnotations.addAll(ExtensionReader.getExtensionsAnnotations((AnnotationTarget)method.declaringClass()));
        }
        for (AnnotationInstance annotation : extensionAnnotations) {
            if (annotation.target() != null && AnnotationTarget.Kind.METHOD_PARAMETER.equals((Object)annotation.target().kind())) continue;
            String name = ExtensionReader.getExtensionName(annotation);
            operation.addExtension(name, ExtensionReader.readExtensionValue(context, name, annotation));
        }
    }

    default public void setOperationOnPathItem(PathItem.HttpMethod methodType, PathItem pathItem, Operation operation) {
        switch (methodType) {
            case DELETE: {
                pathItem.setDELETE(operation);
                break;
            }
            case GET: {
                pathItem.setGET(operation);
                break;
            }
            case HEAD: {
                pathItem.setHEAD(operation);
                break;
            }
            case OPTIONS: {
                pathItem.setOPTIONS(operation);
                break;
            }
            case PATCH: {
                pathItem.setPATCH(operation);
                break;
            }
            case POST: {
                pathItem.setPOST(operation);
                break;
            }
            case PUT: {
                pathItem.setPUT(operation);
                break;
            }
            case TRACE: {
                pathItem.setTRACE(operation);
                break;
            }
        }
    }

    default public void processScannerExtensions(AnnotationScannerContext context, Collection<ClassInfo> applications) {
        for (AnnotationScannerExtension extension : context.getExtensions()) {
            extension.processScannerApplications(this, applications);
        }
    }

    default public void sortTags(OpenAPI openApi, boolean tagsDefined) {
        if (!tagsDefined && openApi.getTags() != null) {
            openApi.setTags(openApi.getTags().stream().sorted(Comparator.comparing(Tag::getName)).collect(Collectors.toList()));
        }
    }

    default public void sortPaths(OpenAPI openApi) {
        Paths paths = openApi.getPaths();
        if (paths != null) {
            PathsImpl sortedPaths = new PathsImpl();
            TreeSet sortedKeys = new TreeSet(paths.getPathItems().keySet());
            for (String pathKey : sortedKeys) {
                PathItem pathItem = paths.getPathItem(pathKey);
                sortedPaths.addPathItem(pathKey, pathItem);
            }
            sortedPaths.setExtensions(paths.getExtensions());
            openApi.setPaths((Paths)sortedPaths);
        }
    }

    default public RequestBody processRequestBody(AnnotationScannerContext context, MethodInfo method, ResourceParameters params) {
        RequestBody requestBody = null;
        List<AnnotationInstance> requestBodyAnnotations = RequestBodyReader.getRequestBodyAnnotations((AnnotationTarget)method);
        for (AnnotationInstance annotation : requestBodyAnnotations) {
            Schema schema;
            requestBody = RequestBodyReader.readRequestBody(context, annotation);
            Content formBodyContent = params.getFormBodyContent();
            if (formBodyContent != null) {
                requestBody.setContent(MergeUtil.mergeObjects(formBodyContent, requestBody.getContent()));
            }
            Type requestBodyType = null;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                requestBodyType = JandexUtil.getMethodParameterType(method, annotation.target().asMethodParameter().position());
            } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                requestBodyType = this.getRequestBodyParameterClassType(method, context.getExtensions());
            }
            if (requestBodyType == null || requestBody.getRef() != null) continue;
            if (!ModelUtil.requestBodyHasSchema(requestBody) && (schema = SchemaFactory.typeToSchema(context, requestBodyType = context.getResourceTypeResolver().resolve(requestBodyType), context.getExtensions())) != null) {
                ModelUtil.setRequestBodySchema(requestBody, schema, this.getConsumes(context));
            }
            if (requestBody.getRequired() != null || !TypeUtil.isOptional(requestBodyType)) continue;
            requestBody.setRequired(Boolean.FALSE);
        }
        if (requestBody == null) {
            requestBody = RequestBodyReader.readRequestBodySchema(context, RequestBodyReader.getRequestBodySchemaAnnotation((AnnotationTarget)method));
        }
        if ((requestBody == null || requestBody.getContent() == null && requestBody.getRef() == null) && this.getConsumes(context) != null) {
            if (params.getFormBodySchema() != null) {
                if (requestBody == null) {
                    requestBody = new RequestBodyImpl();
                }
                Schema schema = params.getFormBodySchema();
                ModelUtil.setRequestBodySchema(requestBody, schema, this.getConsumes(context));
            } else {
                Type requestBodyType = this.getRequestBodyParameterClassType(method, context.getExtensions());
                requestBodyType = context.getResourceTypeResolver().resolve(requestBodyType);
                if (requestBodyType != null && !this.isScannerInternalParameter(requestBodyType)) {
                    SchemaImpl schema = null;
                    if (this.isMultipartInput(requestBodyType)) {
                        schema = new SchemaImpl();
                        schema.setType(Schema.SchemaType.OBJECT);
                    } else {
                        schema = SchemaFactory.typeToSchema(context, requestBodyType, context.getExtensions());
                    }
                    if (requestBody == null) {
                        requestBody = new RequestBodyImpl();
                    }
                    if (schema != null) {
                        ModelUtil.setRequestBodySchema(requestBody, schema, this.getConsumes(context));
                    }
                    if (requestBody.getRequired() == null && TypeUtil.isOptional(requestBodyType)) {
                        requestBody.setRequired(Boolean.FALSE);
                    }
                }
            }
        }
        return requestBody;
    }

    default public String[] getConsumes(AnnotationScannerContext context) {
        String[] currentConsumes = CurrentScannerInfo.getCurrentConsumes();
        if (currentConsumes == null || currentConsumes.length == 0) {
            currentConsumes = context.getConfig().getDefaultConsumes().orElse(null);
        }
        return currentConsumes;
    }

    default public Type getRequestBodyParameterClassType(MethodInfo method, List<AnnotationScannerExtension> extensions) {
        List methodParams = method.parameters();
        if (methodParams.isEmpty()) {
            return null;
        }
        for (short i = 0; i < methodParams.size(); i = (short)(i + 1)) {
            List<AnnotationInstance> parameterAnnotations = JandexUtil.getParameterAnnotations(method, i);
            if (!parameterAnnotations.isEmpty() && this.containsScannerAnnotations(parameterAnnotations, extensions)) continue;
            return (Type)methodParams.get(i);
        }
        return null;
    }

    default public String getReasonPhrase(int statusCode) {
        switch (statusCode) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 102: {
                return "Processing";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 207: {
                return "Multi-Status";
            }
            case 208: {
                return "Already Reported";
            }
            case 226: {
                return "IM Used";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 308: {
                return "Permanent Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Payload Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 418: {
                return "I'm a teapot";
            }
            case 421: {
                return "Misdirected Request";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 424: {
                return "Failed Dependency";
            }
            case 426: {
                return "Upgrade Required";
            }
            case 428: {
                return "Precondition Required";
            }
            case 429: {
                return "Too Many Requests";
            }
            case 431: {
                return "Request Header Fields Too Large";
            }
            case 444: {
                return "Connection Closed Without Response";
            }
            case 451: {
                return "Unavailable For Legal Reasons";
            }
            case 499: {
                return "Client Closed Request";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 506: {
                return "Variant Also Negotiates";
            }
            case 507: {
                return "Insufficient Storage";
            }
            case 508: {
                return "Loop Detected";
            }
            case 510: {
                return "Not Extended";
            }
            case 511: {
                return "Network Authentication Required";
            }
            case 599: {
                return "Network Connect Timeout Error";
            }
        }
        return "Unknown";
    }
}

