/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class MapEntryMarshaller<T extends Map.Entry<Object, Object>>
implements ProtoStreamMarshaller<T> {
    private static final int KEY_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private final Class<? extends T> targetClass;
    private final Function<AbstractMap.SimpleEntry<Object, Object>, T> factory;

    public MapEntryMarshaller(Function<AbstractMap.SimpleEntry<Object, Object>, T> factory) {
        this.targetClass = ((Map.Entry)factory.apply(new AbstractMap.SimpleEntry<Object, Object>(null, null))).getClass();
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        AbstractMap.SimpleEntry<Object, Object> entry = new AbstractMap.SimpleEntry<Object, Object>(null, null);
        boolean reading = true;
        block4: while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    Object key = reader.readObject(Any.class).get();
                    entry = new AbstractMap.SimpleEntry<Object, Object>(key, entry.getValue());
                    continue block4;
                }
                case 2: {
                    Object value = reader.readObject(Any.class).get();
                    entry.setValue(value);
                    continue block4;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return (T)((Map.Entry)this.factory.apply(entry));
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T entry) throws IOException {
        Object key = entry.getKey();
        if (key != null) {
            writer.writeObject(1, new Any(key));
        }
        Object value = entry.getValue();
        if (key != null) {
            writer.writeObject(2, new Any(value));
        }
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

