/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.wildfly.clustering.infinispan.spi.persistence.KeyFormat;
import org.wildfly.clustering.marshalling.spi.Serializer;

public class BinaryKeyFormat<K>
implements KeyFormat<K> {
    private final Class<K> targetClass;
    private final Serializer<K> serializer;

    public BinaryKeyFormat(Class<K> targetClass, Serializer<K> serializer) {
        this.targetClass = targetClass;
        this.serializer = serializer;
    }

    @Override
    public Class<K> getTargetClass() {
        return this.targetClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public K parse(String value) {
        byte[] bytes = Base64.getDecoder().decode(value);
        try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));){
            Object object = this.serializer.read((DataInput)input);
            return (K)object;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String format(K key) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (DataOutputStream output = new DataOutputStream(bytes);){
            this.serializer.write((DataOutput)output, key);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return Base64.getEncoder().encodeToString(bytes.toByteArray());
    }
}

