/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.List;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.SecurityRealmAddHandler;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class SecurityRealmRemoveHandler
extends AbstractRemoveStepHandler {
    public static final SecurityRealmRemoveHandler INSTANCE = new SecurityRealmRemoveHandler(SecurityRealmResourceDefinition.MANAGEMENT_SECURITY_REALM_CAPABILITY);

    private SecurityRealmRemoveHandler(RuntimeCapability ... capabilities) {
        super(capabilities);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performRuntime(context, operation, model);
        boolean reloadRequired = ManagementUtil.isSecurityRealmReloadRequired(context, operation);
        if (reloadRequired) {
            context.reloadRequired();
        } else {
            this.removeServices(context, context.getCurrentAddressValue(), model);
        }
    }

    protected void removeServices(OperationContext context, String realmName, ModelNode model) throws OperationFailedException {
        ServiceName realmServiceName = SecurityRealm.ServiceUtil.createServiceName(realmName);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        List allNames = serviceRegistry.getServiceNames();
        for (ServiceName current : allNames) {
            if (!realmServiceName.isParentOf(current)) continue;
            context.removeService(current);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.recoverServices(context, operation, model);
        try {
            SecurityRealmAddHandler.INSTANCE.installServices(context, context.getCurrentAddressValue(), model);
        }
        catch (OperationFailedException e) {
            throw ControllerLogger.ROOT_LOGGER.failedToRecoverServices(e);
        }
    }
}

