/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.helpers;

import io.smallrye.reactive.messaging.i18n.ProviderExceptions;

public class Validation {
    private Validation() {
    }

    public static <T> T notNull(T instance, String name) {
        if (Validation.isBlank(name)) {
            throw ProviderExceptions.ex.nameMustBeSet();
        }
        if (instance == null) {
            throw ProviderExceptions.ex.validationForNotNull(name);
        }
        return instance;
    }

    public static <T> T[] notEmpty(T[] array, String name) {
        if (Validation.isBlank(name)) {
            throw ProviderExceptions.ex.nameMustBeSet();
        }
        if (array == null) {
            throw ProviderExceptions.ex.validationForNotNull(name);
        }
        if (array.length == 0) {
            throw ProviderExceptions.ex.validationForNotEmpty(name);
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array, String name) {
        if (Validation.isBlank(name)) {
            throw ProviderExceptions.ex.nameMustBeSet();
        }
        if (array == null) {
            throw ProviderExceptions.ex.validationForNotNull(name);
        }
        for (T t : array) {
            if (t != null) continue;
            throw ProviderExceptions.ex.validationForContainsNull(name);
        }
        return array;
    }

    public static boolean isBlank(String string) {
        int strLen;
        if (string == null || (strLen = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void isTrue(boolean mustBeTrue, String message) {
        if (!mustBeTrue) {
            throw ProviderExceptions.ex.validateIsTrue(message);
        }
    }
}

