/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.function.UnaryOperator;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DecoratorMarshaller<T>
implements ProtoStreamMarshaller<T>,
ParametricPrivilegedAction<T, T> {
    static final int DECORATED_INDEX = 1;
    private final Class<? extends T> decoratorClass;
    private final UnaryOperator<T> decorator;
    private final Field field;

    public DecoratorMarshaller(final Class<T> decoratedClass, UnaryOperator<T> decorator, T sample) {
        try {
            this.decorator = decorator;
            final Class<?> decoratorClass = decorator.apply(sample).getClass();
            this.decoratorClass = decoratorClass.asSubclass(decoratedClass);
            this.field = (Field)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    Field field = DecoratorMarshaller.findDecoratedField(decoratorClass, decoratedClass);
                    field.setAccessible(true);
                    return field;
                }
            });
        }
        catch (Error | RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    static Field findDecoratedField(Class<?> decoratorClass, Class<?> decoratedClass) {
        for (Field field : decoratorClass.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(decoratedClass)) continue;
            return field;
        }
        Class<?> superClass = decoratorClass.getSuperclass();
        if (superClass == null) {
            throw new IllegalStateException();
        }
        return DecoratorMarshaller.findDecoratedField(superClass, decoratedClass);
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.decoratorClass;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Object decorated = null;
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    decorated = reader.readObject(Any.class).get();
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return (T)this.decorator.apply(decorated);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T value) throws IOException {
        Object decorated = WildFlySecurityManager.doUnchecked(value, (ParametricPrivilegedAction)this);
        if (decorated != null) {
            writer.writeObject(1, new Any(decorated));
        }
    }

    public T run(T value) {
        try {
            return (T)this.field.get(value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

