/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxb.intros;

import java.lang.annotation.Annotation;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final ConvertUtilsBean CONVERT_UTILS = new ConvertUtilsBean();

    private Util() {
    }

    public static Object getProperty(Object obj, String name) {
        try {
            return PropertyUtils.getProperty((Object)obj, (String)name);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("failed to get property %s from object %s", name, obj), e);
        }
    }

    public static Object getProperty(Object obj, Class<? extends Annotation> annotation) {
        return Util.getProperty(obj, Util.getPropertyName(annotation));
    }

    private static String getPropertyName(Class<?> cls) {
        String name = cls.getSimpleName();
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static Object convert(Object value, Class<?> returnType) {
        if (value == null) {
            return null;
        }
        if (value != null && !Util.nonPrimitive(returnType).isAssignableFrom(Util.nonPrimitive(value.getClass()))) {
            if (returnType.isEnum()) {
                return Util.convertEnum(returnType, value.toString());
            }
            value = CONVERT_UTILS.convert(value.toString(), returnType);
        }
        return value;
    }

    private static Object convertEnum(Class returnType, String value) {
        return Enum.valueOf(returnType, value);
    }

    public static Class<?> nonPrimitive(Class<?> cls) {
        if (!cls.isPrimitive()) {
            return cls;
        }
        if (Boolean.TYPE == cls) {
            return Boolean.class;
        }
        if (Byte.TYPE == cls) {
            return Byte.class;
        }
        if (Character.TYPE == cls) {
            return Character.class;
        }
        if (Short.TYPE == cls) {
            return Short.class;
        }
        if (Integer.TYPE == cls) {
            return Integer.class;
        }
        if (Long.TYPE == cls) {
            return Long.class;
        }
        if (Float.TYPE == cls) {
            return Float.class;
        }
        if (Byte.TYPE == cls) {
            return Double.class;
        }
        if (Void.TYPE == cls) {
            return Void.class;
        }
        throw new RuntimeException("undiscovered primitive type? " + cls.getName());
    }
}

