/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.IoMessages;
import io.smallrye.openapi.runtime.io.definition.DefinitionReader;
import io.smallrye.openapi.runtime.io.schema.SchemaReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class OpenApiParser {
    private final JsonNode tree;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final OpenAPI parse(URL url) throws IOException {
        try {
            boolean isYaml;
            String fname = url.getFile();
            if (fname == null) {
                throw IoMessages.msg.noFileName(url.toURI().toString());
            }
            int lidx = fname.lastIndexOf(46);
            if (lidx == -1) throw IoMessages.msg.invalidFileName(url.toURI().toString());
            if (lidx >= fname.length()) {
                throw IoMessages.msg.invalidFileName(url.toURI().toString());
            }
            String ext = fname.substring(lidx + 1);
            boolean isJson = ext.equalsIgnoreCase("json");
            boolean bl = isYaml = ext.equalsIgnoreCase("yaml") || ext.equalsIgnoreCase("yml");
            if (!isJson && !isYaml) {
                throw IoMessages.msg.invalidFileExtension(url.toURI().toString());
            }
            try (InputStream stream = url.openStream();){
                OpenAPI openAPI = OpenApiParser.parse(stream, isJson ? Format.JSON : Format.YAML);
                return openAPI;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static final OpenAPI parse(InputStream stream, Format format) throws IOException {
        ObjectMapper mapper = format == Format.JSON ? new ObjectMapper() : new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode tree = mapper.readTree(stream);
        OpenApiParser parser = new OpenApiParser(tree);
        return parser.parse();
    }

    public static final Schema parseSchema(String schemaJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode tree = mapper.readTree(schemaJson);
        return SchemaReader.readSchema(tree);
    }

    public OpenApiParser(JsonNode tree) {
        this.tree = tree;
    }

    private OpenAPI parse() {
        OpenAPIImpl oai = new OpenAPIImpl();
        DefinitionReader.processDefinition(oai, this.tree);
        return oai;
    }
}

