/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.example;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.examples.ExampleImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ExampleReader {
    private ExampleReader() {
    }

    public static Map<String, Example> readExamples(AnnotationValue annotationValue) {
        AnnotationInstance[] nestedArray;
        if (annotationValue == null) {
            return null;
        }
        IoLogging.logger.annotationsMap("@ExampleObject");
        LinkedHashMap<String, Example> examples = new LinkedHashMap<String, Example>();
        for (AnnotationInstance nested : nestedArray = annotationValue.asNestedArray()) {
            String name = JandexUtil.stringValue(nested, "name");
            if (name == null && JandexUtil.isRef(nested)) {
                name = JandexUtil.nameFromRef(nested);
            }
            if (name == null) continue;
            examples.put(name, ExampleReader.readExample(nested));
        }
        return examples;
    }

    public static Map<String, Example> readExamples(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        LinkedHashMap<String, Example> examples = new LinkedHashMap<String, Example>();
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode childNode = node.get(fieldName);
            examples.put(fieldName, ExampleReader.readExample(childNode));
        }
        return examples;
    }

    private static Example readExample(AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.logger.singleAnnotation("@ExampleObject");
        ExampleImpl example = new ExampleImpl();
        example.setRef(JandexUtil.refValue(annotationInstance, JandexUtil.RefType.EXAMPLE));
        example.setSummary(JandexUtil.stringValue(annotationInstance, "summary"));
        example.setDescription(JandexUtil.stringValue(annotationInstance, "description"));
        example.setValue(JandexUtil.stringValue(annotationInstance, "value"));
        example.setExternalValue(JandexUtil.stringValue(annotationInstance, "externalValue"));
        return example;
    }

    private static Example readExample(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonNode("ExampleObject");
        ExampleImpl example = new ExampleImpl();
        example.setRef(JsonUtil.stringProperty(node, "$ref"));
        example.setSummary(JsonUtil.stringProperty(node, "summary"));
        example.setDescription(JsonUtil.stringProperty(node, "description"));
        example.setValue(JsonUtil.readObject(node.get("value")));
        example.setExternalValue(JsonUtil.stringProperty(node, "externalValue"));
        ExtensionReader.readExtensions(node, example);
        return example;
    }
}

