/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Objects;
import org.infinispan.commons.util.Util;

public class SegmentAwareKey<K> {
    private final K key;
    private final int segment;

    public SegmentAwareKey(K key, int segment) {
        this.key = Objects.requireNonNull(key);
        this.segment = segment;
    }

    public K getKey() {
        return this.key;
    }

    public int getSegment() {
        return this.segment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentAwareKey that = (SegmentAwareKey)o;
        return this.segment == that.segment && this.key.equals(that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.segment);
    }

    public String toString() {
        return "SegmentAwareKey{key=" + Util.toStr(this.key) + ", segment=" + this.segment + '}';
    }
}

