/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.RuntimeTypeInfo;
import org.eclipse.yasson.internal.VariableTypeInheritanceSearch;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;
import org.eclipse.yasson.internal.serializer.ResolvedParameterizedType;

public class ReflectionUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtils.class.getName());

    private ReflectionUtils() {
        throw new IllegalStateException("Utility classes should not be instantiated.");
    }

    public static Optional<Class<?>> getOptionalRawType(Type type) {
        TypeVariable typeVariable;
        if (type instanceof Class) {
            return Optional.of((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return Optional.of((Class)((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Optional.of(((GenericArrayType)type).getClass());
        }
        if (type instanceof TypeVariable && Objects.nonNull((typeVariable = (TypeVariable)TypeVariable.class.cast(type)).getBounds())) {
            Optional<Class<?>> specializedClass = Optional.empty();
            for (Type bound : typeVariable.getBounds()) {
                Optional<Class<?>> boundRawType = ReflectionUtils.getOptionalRawType(bound);
                if (!boundRawType.isPresent() || Object.class.equals(boundRawType.get()) || specializedClass.isPresent() && !specializedClass.get().isAssignableFrom(boundRawType.get())) continue;
                specializedClass = Optional.of(boundRawType.get());
            }
            return specializedClass;
        }
        return Optional.empty();
    }

    public static Class<?> getRawType(Type type) {
        return ReflectionUtils.getOptionalRawType(type).orElseThrow(() -> new JsonbException(Messages.getMessage(MessageKeys.TYPE_RESOLUTION_ERROR, type)));
    }

    public static Class<?> resolveRawType(RuntimeTypeInfo item, Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return ReflectionUtils.getRawType(ReflectionUtils.resolveType(item, type));
    }

    public static Type resolveType(RuntimeTypeInfo item, Type type) {
        return ReflectionUtils.resolveType(item, type, true);
    }

    private static Type resolveType(RuntimeTypeInfo item, Type type, boolean warn) {
        if (type instanceof WildcardType) {
            return ReflectionUtils.resolveMostSpecificBound(item, (WildcardType)type, warn);
        }
        if (type instanceof TypeVariable) {
            return ReflectionUtils.resolveItemVariableType(item, (TypeVariable)type, warn);
        }
        if (type instanceof ParameterizedType && item != null) {
            return ReflectionUtils.resolveTypeArguments((ParameterizedType)type, item.getRuntimeType());
        }
        return type;
    }

    public static Optional<Type> resolveOptionalType(RuntimeTypeInfo info, Type type) {
        try {
            return Optional.of(ReflectionUtils.resolveType(info, type, false));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    static Type resolveItemVariableType(RuntimeTypeInfo item, TypeVariable<?> typeVariable, boolean warn) {
        if (item == null) {
            Optional<Class<?>> optionalRawType = ReflectionUtils.getOptionalRawType(typeVariable);
            if (optionalRawType.isPresent()) {
                return optionalRawType.get();
            }
            if (warn) {
                LOGGER.warning(Messages.getMessage(MessageKeys.GENERIC_BOUND_NOT_FOUND, typeVariable, typeVariable.getGenericDeclaration()));
            }
            return Object.class;
        }
        if (item instanceof EmbeddedItem) {
            return ReflectionUtils.resolveItemVariableType(item.getWrapper(), typeVariable, warn);
        }
        VariableTypeInheritanceSearch search = new VariableTypeInheritanceSearch();
        ParameterizedType wrapperParameterizedType = ReflectionUtils.findParameterizedSuperclass(item.getRuntimeType());
        Type foundType = search.searchParametrizedType(wrapperParameterizedType, typeVariable);
        if (foundType != null) {
            if (foundType instanceof TypeVariable) {
                return ReflectionUtils.resolveItemVariableType(item.getWrapper(), (TypeVariable)foundType, warn);
            }
            return foundType;
        }
        return ReflectionUtils.resolveItemVariableType(item.getWrapper(), typeVariable, warn);
    }

    public static Type resolveTypeArguments(ParameterizedType typeToResolve, Type typeToSearch) {
        Object[] unresolvedArgs = typeToResolve.getActualTypeArguments();
        Object[] resolvedArgs = new Type[unresolvedArgs.length];
        for (int i = 0; i < unresolvedArgs.length; ++i) {
            if (!(unresolvedArgs[i] instanceof TypeVariable)) {
                resolvedArgs[i] = unresolvedArgs[i];
            } else {
                resolvedArgs[i] = new VariableTypeInheritanceSearch().searchParametrizedType(typeToSearch, (TypeVariable)unresolvedArgs[i]);
                if (resolvedArgs[i] == null) {
                    throw new IllegalStateException(Messages.getMessage(MessageKeys.GENERIC_BOUND_NOT_FOUND, unresolvedArgs[i], typeToSearch));
                }
            }
            if (!(resolvedArgs[i] instanceof ParameterizedType)) continue;
            resolvedArgs[i] = ReflectionUtils.resolveTypeArguments((ParameterizedType)resolvedArgs[i], typeToSearch);
        }
        return Arrays.equals(resolvedArgs, unresolvedArgs) ? typeToResolve : new ResolvedParameterizedType(typeToResolve, (Type[])resolvedArgs);
    }

    public static <T> T createNoArgConstructorInstance(Constructor<T> constructor) {
        Objects.requireNonNull(constructor);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JsonbException("Can't create instance", (Throwable)e);
        }
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz, boolean required) {
        Objects.requireNonNull(clazz);
        return AccessController.doPrivileged(() -> {
            try {
                Constructor declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
                if (declaredConstructor.getModifiers() == 4) {
                    declaredConstructor.setAccessible(true);
                }
                return declaredConstructor;
            }
            catch (NoSuchMethodException | RuntimeException e) {
                if (required) {
                    throw new JsonbException(Messages.getMessage(MessageKeys.NO_DEFAULT_CONSTRUCTOR, clazz), (Throwable)e);
                }
                return null;
            }
        });
    }

    public static ParameterizedType findParameterizedType(Class<?> classToSearch, Class<?> parameterizedInterface) {
        for (Class<?> current = classToSearch; current != Object.class; current = current.getSuperclass()) {
            for (Type currentInterface : current.getGenericInterfaces()) {
                if (!(currentInterface instanceof ParameterizedType) || !parameterizedInterface.isAssignableFrom(ReflectionUtils.getRawType(((ParameterizedType)currentInterface).getRawType()))) continue;
                return (ParameterizedType)currentInterface;
            }
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.NON_PARAMETRIZED_TYPE, parameterizedInterface));
    }

    public static boolean isResolvedType(Type type) {
        if (type instanceof ParameterizedType) {
            for (Type typeArg : ((ParameterizedType)type).getActualTypeArguments()) {
                if (ReflectionUtils.isResolvedType(typeArg)) continue;
                return false;
            }
            return true;
        }
        return type instanceof Class;
    }

    private static ParameterizedType findParameterizedSuperclass(Type type) {
        if (type == null || type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (!(type instanceof Class)) {
            throw new JsonbException("Can't resolve ParameterizedType superclass for: " + type);
        }
        return ReflectionUtils.findParameterizedSuperclass(((Class)type).getGenericSuperclass());
    }

    private static Type resolveMostSpecificBound(RuntimeTypeInfo item, WildcardType wildcardType, boolean warn) {
        Class result = Object.class;
        for (Type upperBound : wildcardType.getUpperBounds()) {
            result = ReflectionUtils.getMostSpecificBound(item, result, upperBound, warn);
        }
        for (Type lowerBound : wildcardType.getLowerBounds()) {
            result = ReflectionUtils.getMostSpecificBound(item, result, lowerBound, warn);
        }
        return result;
    }

    private static Class<?> getMostSpecificBound(RuntimeTypeInfo item, Class<?> result, Type bound, boolean warn) {
        if (bound == Object.class) {
            return result;
        }
        Type resolvedBoundType = bound instanceof TypeVariable ? ReflectionUtils.resolveType(item, bound, warn) : bound;
        Class<?> boundRawType = ReflectionUtils.getRawType(resolvedBoundType);
        if (result.isAssignableFrom(boundRawType)) {
            result = boundRawType;
        }
        return result;
    }
}

