/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueAdd;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueConfigurationRuntimeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueControlHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueReadAttributeHandler;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueRemove;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueUpdateJndiHandler;

public class JMSQueueDefinition
extends PersistentResourceDefinition {
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.DESTINATION_ENTRIES, CommonAttributes.SELECTOR, CommonAttributes.DURABLE, CommonAttributes.LEGACY_ENTRIES};
    static AttributeDefinition[] DEPLOYMENT_ATTRIBUTES = new AttributeDefinition[]{((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(CommonAttributes.DESTINATION_ENTRIES).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.SELECTOR).setStorageRuntime()).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.DURABLE).setStorageRuntime()).build(), ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(CommonAttributes.LEGACY_ENTRIES).setStorageRuntime()).build()};
    static final AttributeDefinition QUEUE_ADDRESS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"queue-address", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final AttributeDefinition DEAD_LETTER_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"dead-letter-address", (ModelType)ModelType.STRING).setRequired(false)).setStorageRuntime()).build();
    static final AttributeDefinition EXPIRY_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"expiry-address", (ModelType)ModelType.STRING).setRequired(false)).setStorageRuntime()).build();
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{QUEUE_ADDRESS, EXPIRY_ADDRESS, DEAD_LETTER_ADDRESS, CommonAttributes.PAUSED, CommonAttributes.TEMPORARY};
    static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.MESSAGE_COUNT, CommonAttributes.DELIVERING_COUNT, CommonAttributes.MESSAGES_ADDED, CommonAttributes.SCHEDULED_COUNT, CommonAttributes.CONSUMER_COUNT};
    private final boolean deployed;
    private final boolean registerRuntimeOnly;

    public JMSQueueDefinition(boolean deployed, boolean registerRuntimeOnly) {
        super(MessagingExtension.JMS_QUEUE_PATH, MessagingExtension.getResourceDescriptionResolver("jms-queue"), (OperationStepHandler)(deployed ? null : JMSQueueAdd.INSTANCE), (OperationStepHandler)(deployed ? null : JMSQueueRemove.INSTANCE));
        this.deployed = deployed;
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public Collection<AttributeDefinition> getAttributes() {
        if (this.deployed) {
            return Arrays.asList(DEPLOYMENT_ATTRIBUTES);
        }
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        ReloadRequiredWriteAttributeHandler handler = new ReloadRequiredWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attr : this.getAttributes()) {
            if (this.deployed) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSQueueConfigurationRuntimeHandler.INSTANCE);
                continue;
            }
            if (attr == CommonAttributes.DESTINATION_ENTRIES || attr == CommonAttributes.LEGACY_ENTRIES) {
                registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
                continue;
            }
            registry.registerReadOnlyAttribute(attr, null);
        }
        for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
            registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSQueueReadAttributeHandler.INSTANCE);
        }
        for (AttributeDefinition metric : METRICS) {
            registry.registerMetric(metric, (OperationStepHandler)JMSQueueReadAttributeHandler.INSTANCE);
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            JMSQueueControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
            if (!this.deployed) {
                JMSQueueUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
            }
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Arrays.asList(MessagingExtension.JMS_QUEUE_ACCESS_CONSTRAINT);
    }
}

