/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.AbstractTableManager;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.util.logging.LogFactory;

class MySQLTableManager
extends AbstractTableManager {
    private static final Log log = (Log)LogFactory.getLog(MySQLTableManager.class, Log.class);

    MySQLTableManager(InitializationContext ctx, ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData, String cacheName) {
        super(ctx, connectionFactory, config, metaData, cacheName, "`", log);
    }

    @Override
    public int getFetchSize() {
        return Integer.MIN_VALUE;
    }

    @Override
    public String initUpsertRowSql() {
        if (this.dbMetadata.isSegmentedDisabled()) {
            return String.format("%1$s ON DUPLICATE KEY UPDATE %2$s = VALUES(%2$s), %3$s = VALUES(%3$s)", this.getInsertRowSql(), this.config.dataColumnName(), this.config.timestampColumnName());
        }
        return String.format("%1$s ON DUPLICATE KEY UPDATE %2$s = VALUES(%2$s), %3$s = VALUES(%3$s), %4$s = VALUES(%4$s)", this.getInsertRowSql(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.segmentColumnName());
    }
}

