/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml.metadata;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.ParserNamespaceSupport;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.identity.federation.core.parsers.saml.metadata.AbstractDescriptorParser;
import org.picketlink.identity.federation.core.parsers.saml.metadata.SAMLEntityDescriptorParser;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.ExtensionsType;
import org.w3c.dom.Element;

public class SAMLEntitiesDescriptorParser
extends AbstractDescriptorParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final String EDT = JBossSAMLConstants.ENTITIES_DESCRIPTOR.get();

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute cacheDuration;
        Attribute name;
        Attribute id;
        xmlEventReader = this.filterWhiteSpaceCharacters(xmlEventReader);
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)this.EDT);
        EntitiesDescriptorType entitiesDescriptorType = new EntitiesDescriptorType();
        Attribute validUntil = startElement.getAttributeByName(new QName(JBossSAMLConstants.VALID_UNTIL.get()));
        if (validUntil != null) {
            String validUntilValue = StaxParserUtil.getAttributeValue((Attribute)validUntil);
            entitiesDescriptorType.setValidUntil(XMLTimeUtil.parse(validUntilValue));
        }
        if ((id = startElement.getAttributeByName(new QName(JBossSAMLConstants.ID.get()))) != null) {
            entitiesDescriptorType.setID(StaxParserUtil.getAttributeValue((Attribute)id));
        }
        if ((name = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME.get()))) != null) {
            entitiesDescriptorType.setName(StaxParserUtil.getAttributeValue((Attribute)name));
        }
        if ((cacheDuration = startElement.getAttributeByName(new QName(JBossSAMLConstants.CACHE_DURATION.get()))) != null) {
            entitiesDescriptorType.setCacheDuration(XMLTimeUtil.parseAsDuration(StaxParserUtil.getAttributeValue((Attribute)cacheDuration)));
        }
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                StaxParserUtil.validate((EndElement)((EndElement)xmlEvent), (String)this.EDT);
                StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                break;
            }
            startElement = (StartElement)xmlEvent;
            String localPart = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ENTITY_DESCRIPTOR.get().equals(localPart)) {
                SAMLEntityDescriptorParser entityParser = new SAMLEntityDescriptorParser();
                entitiesDescriptorType.addEntityDescriptor(entityParser.parse(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equalsIgnoreCase(localPart)) {
                entitiesDescriptorType.setExtensions(this.parseExtensions(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ENTITIES_DESCRIPTOR.get().equalsIgnoreCase(localPart)) {
                SAMLEntitiesDescriptorParser parser = new SAMLEntitiesDescriptorParser();
                entitiesDescriptorType.addEntityDescriptor(parser.parse(xmlEventReader));
                continue;
            }
            if (localPart.equals(JBossSAMLConstants.SIGNATURE.get())) {
                entitiesDescriptorType.setSignature(StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(localPart, startElement.getLocation());
        }
        return entitiesDescriptorType;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(this.EDT);
    }

    private ExtensionsType parseExtensions(XMLEventReader xmlEventReader) throws ParsingException {
        ExtensionsType extensions = new ExtensionsType();
        Element extElement = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
        extensions.setElement(extElement);
        return extensions;
    }
}

