/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface Cipher
extends CipherInformation {
    public void init(Mode var1, byte[] var2, byte[] var3) throws Exception;

    default public void update(byte[] input) throws Exception {
        this.update(input, 0, NumberUtils.length(input));
    }

    public void update(byte[] var1, int var2, int var3) throws Exception;

    public static boolean checkSupported(String xform, int keyLength) {
        ValidateUtils.checkNotNullAndNotEmpty(xform, "No transformation");
        if (keyLength <= 0) {
            throw new IllegalArgumentException("Bad key length (" + keyLength + ") for cipher=" + xform);
        }
        try {
            int maxKeyLength = javax.crypto.Cipher.getMaxAllowedKeyLength(xform);
            return maxKeyLength >= keyLength;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum Mode {
        Encrypt,
        Decrypt;

    }
}

