/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.Util;
import org.infinispan.persistence.remote.configuration.Attribute;
import org.infinispan.persistence.remote.configuration.Element;

public class TrustStoreConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> TRUSTSTORE_FILENAME = AttributeDefinition.builder((String)"trustStoreFilename", null, String.class).immutable().autoPersist(false).xmlName(Attribute.FILENAME.getLocalName()).build();
    static final AttributeDefinition<String> TRUSTSTORE_TYPE = AttributeDefinition.builder((String)"trustStoreType", (Object)"JKS", String.class).immutable().autoPersist(false).xmlName(Attribute.TYPE.getLocalName()).build();
    static final AttributeDefinition<String> TRUSTSTORE_PASSWORD = AttributeDefinition.builder((String)"trustStorePassword", null, String.class).immutable().autoPersist(false).xmlName(Attribute.PASSWORD.getLocalName()).build();
    static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.TRUSTSTORE.getLocalName());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TrustStoreConfiguration.class, new AttributeDefinition[]{TRUSTSTORE_FILENAME, TRUSTSTORE_TYPE, TRUSTSTORE_PASSWORD});
    }

    TrustStoreConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String trustStoreFileName() {
        return (String)this.attributes.attribute(TRUSTSTORE_FILENAME).get();
    }

    public String trustStoreType() {
        return (String)this.attributes.attribute(TRUSTSTORE_TYPE).get();
    }

    public char[] trustStorePassword() {
        return Util.toCharArray((String)((String)this.attributes.attribute(TRUSTSTORE_PASSWORD).get()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustStoreConfiguration that = (TrustStoreConfiguration)o;
        return this.attributes != null ? this.attributes.equals((Object)that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }
}

