/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup;

import io.smallrye.metrics.MetricsRegistryImpl;
import io.smallrye.metrics.OriginAndMetadata;
import io.smallrye.metrics.TagsUtils;
import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.elementdesc.MemberInfo;
import io.smallrye.metrics.interceptors.MetricResolver;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricsMetadata {
    private MetricsMetadata() {
    }

    public static List<MetricID> registerMetrics(MetricRegistry registry, MetricResolver resolver, BeanInfo bean, MemberInfo element) {
        MetricResolver.Of<Timed> timed;
        MetricResolver.Of<SimplyTimed> simplyTimed;
        MetricResolver.Of<Metered> metered;
        MetricResolver.Of<ConcurrentGauge> concurrentGauge;
        MetricResolver.Of<Counted> counted = resolver.counted(bean, element);
        ArrayList<MetricID> metricIDs = new ArrayList<MetricID>();
        if (counted.isPresent()) {
            AnnotationInfo t = counted.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, counted.metricName(), t.unit(), t.description(), t.displayName(), MetricType.COUNTER);
            Tag[] tags = TagsUtils.parseTagsAsArray(t.tags());
            registry.counter(metadata, tags);
            if (registry instanceof MetricsRegistryImpl) {
                MetricID metricID = new MetricID(metadata.getName(), tags);
                metricIDs.add(metricID);
                ((MetricsRegistryImpl)registry).getMemberToMetricMappings().addMetric(element, metricID, MetricType.COUNTER);
            }
        }
        if ((concurrentGauge = resolver.concurrentGauge(bean, element)).isPresent()) {
            AnnotationInfo t = concurrentGauge.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, concurrentGauge.metricName(), t.unit(), t.description(), t.displayName(), MetricType.CONCURRENT_GAUGE);
            Tag[] tags = TagsUtils.parseTagsAsArray(t.tags());
            registry.concurrentGauge(metadata, tags);
            if (registry instanceof MetricsRegistryImpl) {
                MetricID metricID = new MetricID(metadata.getName(), tags);
                metricIDs.add(metricID);
                ((MetricsRegistryImpl)registry).getMemberToMetricMappings().addMetric(element, metricID, MetricType.CONCURRENT_GAUGE);
            }
        }
        if ((metered = resolver.metered(bean, element)).isPresent()) {
            AnnotationInfo t = metered.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, metered.metricName(), t.unit(), t.description(), t.displayName(), MetricType.METERED);
            Tag[] tags = TagsUtils.parseTagsAsArray(t.tags());
            registry.meter(metadata, tags);
            if (registry instanceof MetricsRegistryImpl) {
                MetricID metricID = new MetricID(metadata.getName(), tags);
                metricIDs.add(metricID);
                ((MetricsRegistryImpl)registry).getMemberToMetricMappings().addMetric(element, metricID, MetricType.METERED);
            }
        }
        if ((simplyTimed = resolver.simplyTimed(bean, element)).isPresent()) {
            AnnotationInfo t = simplyTimed.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, simplyTimed.metricName(), t.unit(), t.description(), t.displayName(), MetricType.SIMPLE_TIMER);
            Tag[] tags = TagsUtils.parseTagsAsArray(t.tags());
            registry.simpleTimer(metadata, tags);
            if (registry instanceof MetricsRegistryImpl) {
                MetricID metricID = new MetricID(metadata.getName(), tags);
                metricIDs.add(metricID);
                ((MetricsRegistryImpl)registry).getMemberToMetricMappings().addMetric(element, metricID, MetricType.SIMPLE_TIMER);
            }
        }
        if ((timed = resolver.timed(bean, element)).isPresent()) {
            AnnotationInfo t = timed.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, timed.metricName(), t.unit(), t.description(), t.displayName(), MetricType.TIMER);
            Tag[] tags = TagsUtils.parseTagsAsArray(t.tags());
            registry.timer(metadata, tags);
            if (registry instanceof MetricsRegistryImpl) {
                MetricID metricID = new MetricID(metadata.getName(), tags);
                metricIDs.add(metricID);
                ((MetricsRegistryImpl)registry).getMemberToMetricMappings().addMetric(element, metricID, MetricType.TIMER);
            }
        }
        return metricIDs;
    }

    public static Metadata getMetadata(Object origin, String name, String unit, String description, String displayName, MetricType type) {
        Metadata metadata = Metadata.builder().withName(name).withType(type).withUnit(unit).withDescription(description).withDisplayName(displayName).build();
        return new OriginAndMetadata(origin, metadata);
    }
}

