/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.service.AbstractService;
import org.jboss.as.service.component.ServiceComponentInstantiator;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class CreateDestroyService
extends AbstractService {
    private final Method createMethod;
    private final Method destroyMethod;
    private final ServiceComponentInstantiator componentInstantiator;
    private final Map<Method, Supplier<Object>> injections = new HashMap<Method, Supplier<Object>>();
    private ManagedReference managedReference;

    CreateDestroyService(Object mBeanInstance, Method createMethod, Method destroyMethod, ServiceComponentInstantiator componentInstantiator, List<SetupAction> setupActions, ClassLoader mbeanContextClassLoader, Consumer<Object> mBeanInstanceConsumer, Supplier<ExecutorService> executorSupplier) {
        super(mBeanInstance, setupActions, mbeanContextClassLoader, mBeanInstanceConsumer, executorSupplier);
        this.createMethod = createMethod;
        this.destroyMethod = destroyMethod;
        this.componentInstantiator = componentInstantiator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(final StartContext context) {
        super.start(context);
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Creating Service: %s", context.getController().getName());
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    CreateDestroyService.this.injectDependencies();
                    CreateDestroyService.this.invokeLifecycleMethod(CreateDestroyService.this.createMethod, (LifecycleContext)context);
                    if (CreateDestroyService.this.componentInstantiator != null) {
                        CreateDestroyService.this.managedReference = CreateDestroyService.this.componentInstantiator.initializeInstance(CreateDestroyService.this.mBeanInstance);
                    }
                    context.complete();
                }
                catch (Throwable e) {
                    CreateDestroyService.this.uninjectDependencies();
                    context.failed(new StartException(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("create()"), e));
                }
            }
        };
        try {
            ((ExecutorService)this.executorSupplier.get()).submit(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(final StopContext context) {
        super.stop(context);
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Destroying Service: %s", context.getController().getName());
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    if (CreateDestroyService.this.managedReference != null) {
                        CreateDestroyService.this.managedReference.release();
                    }
                    CreateDestroyService.this.invokeLifecycleMethod(CreateDestroyService.this.destroyMethod, (LifecycleContext)context);
                }
                catch (Exception e) {
                    SarLogger.ROOT_LOGGER.error(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("destroy()"), e);
                }
                finally {
                    CreateDestroyService.this.uninjectDependencies();
                    context.complete();
                }
            }
        };
        try {
            ((ExecutorService)this.executorSupplier.get()).submit(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    void inject(Method setter, Supplier<Object> injectionSupplier) {
        this.injections.put(setter, injectionSupplier);
    }

    private void injectDependencies() throws IllegalAccessException, InvocationTargetException {
        for (Map.Entry<Method, Supplier<Object>> injection : this.injections.entrySet()) {
            Method setter = injection.getKey();
            Object arg = injection.getValue().get();
            setter.invoke(this.mBeanInstance, arg);
        }
    }

    private void uninjectDependencies() {
        for (Map.Entry<Method, Supplier<Object>> injection : this.injections.entrySet()) {
            try {
                Method setter = injection.getKey();
                setter.invoke(this.mBeanInstance, (Object[])null);
            }
            catch (Throwable throwable) {}
        }
    }
}

