/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wildfly.clustering.ee.Manager;

public class ConcurrentManager<K, V>
implements Manager<K, V> {
    private final Map<K, Map.Entry<Integer, AtomicReference<V>>> objects = new ConcurrentHashMap<K, Map.Entry<Integer, AtomicReference<V>>>();
    private final BiFunction<K, Map.Entry<Integer, AtomicReference<V>>, Map.Entry<Integer, AtomicReference<V>>> addFunction = new BiFunction<K, Map.Entry<Integer, AtomicReference<V>>, Map.Entry<Integer, AtomicReference<V>>>(){

        @Override
        public Map.Entry<Integer, AtomicReference<V>> apply(K id, Map.Entry<Integer, AtomicReference<V>> entry) {
            Integer count = entry != null ? entry.getKey() + 1 : 0;
            AtomicReference reference = entry != null ? entry.getValue() : new AtomicReference();
            return new AbstractMap.SimpleImmutableEntry(count, reference);
        }
    };
    private final Consumer<V> createTask;
    private final BiFunction<K, Map.Entry<Integer, AtomicReference<V>>, Map.Entry<Integer, AtomicReference<V>>> removeFunction;

    public ConcurrentManager(Consumer<V> createTask, final Consumer<V> closeTask) {
        this.createTask = createTask;
        this.removeFunction = new BiFunction<K, Map.Entry<Integer, AtomicReference<V>>, Map.Entry<Integer, AtomicReference<V>>>(){

            @Override
            public Map.Entry<Integer, AtomicReference<V>> apply(K key, Map.Entry<Integer, AtomicReference<V>> entry) {
                AtomicReference reference;
                int count = entry != null ? entry.getKey() : 0;
                AtomicReference atomicReference = reference = entry != null ? entry.getValue() : null;
                if (count == 0) {
                    Object value;
                    Object t = value = reference != null ? (Object)reference.get() : null;
                    if (value != null) {
                        closeTask.accept(value);
                    }
                    return null;
                }
                return new AbstractMap.SimpleImmutableEntry(count - 1, reference);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V apply(final K key, Function<Runnable, V> factory) {
        Map.Entry<Integer, AtomicReference<V>> entry = this.objects.compute(key, this.addFunction);
        AtomicReference<V> reference = entry.getValue();
        if (reference.get() == null) {
            AtomicReference<V> atomicReference = reference;
            synchronized (atomicReference) {
                if (reference.get() == null) {
                    final Map<K, Map.Entry<Integer, AtomicReference<V>>> objects = this.objects;
                    final BiFunction<K, Map.Entry<Integer, AtomicReference<V>>, Map.Entry<Integer, AtomicReference<V>>> removeFunction = this.removeFunction;
                    Runnable closeTask = new Runnable(){

                        @Override
                        public void run() {
                            objects.compute(key, removeFunction);
                        }
                    };
                    V value = factory.apply(closeTask);
                    if (value != null) {
                        this.createTask.accept(value);
                        reference.set(value);
                    } else {
                        closeTask.run();
                    }
                }
            }
        }
        return reference.get();
    }
}

