/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.security.AccessController;
import java.security.KeyPair;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import org.jboss.as.webservices.util.SimpleGroup;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.PublicKeyCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.credential.X509CertificateChainPublicCredential;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.Password;

public final class SubjectUtil {
    private static final Class<?> groupClass;

    public static Subject fromSecurityIdentity(SecurityIdentity securityIdentity) {
        return SubjectUtil.fromSecurityIdentity(securityIdentity, new Subject());
    }

    public static Subject fromSecurityIdentity(SecurityIdentity securityIdentity, Subject subject) {
        if (subject == null) {
            subject = new Subject();
        }
        subject.getPrincipals().add(securityIdentity.getPrincipal());
        Roles identityRoles = securityIdentity.getRoles();
        if (groupClass != null) {
            SimpleGroup rolesGroup = new SimpleGroup("Roles");
            for (String role : identityRoles) {
                rolesGroup.addMember((Principal)new NamePrincipal(role));
            }
            subject.getPrincipals().add((Principal)((Object)rolesGroup));
            SimpleGroup callerPrincipalGroup = new SimpleGroup("CallerPrincipal");
            callerPrincipalGroup.addMember(securityIdentity.getPrincipal());
            subject.getPrincipals().add((Principal)((Object)callerPrincipalGroup));
        } else {
            String principalName = securityIdentity.getPrincipal().getName();
            Set<Principal> principals = subject.getPrincipals();
            for (String role : identityRoles) {
                if (principalName.equals(role)) continue;
                principals.add((Principal)new NamePrincipal(role));
            }
        }
        for (Credential credential : securityIdentity.getPublicCredentials()) {
            if (credential instanceof PublicKeyCredential) {
                subject.getPublicCredentials().add(((PublicKeyCredential)credential.castAs(PublicKeyCredential.class)).getPublicKey());
                continue;
            }
            if (credential instanceof X509CertificateChainPublicCredential) {
                subject.getPublicCredentials().add(((X509CertificateChainPublicCredential)credential.castAs(X509CertificateChainPublicCredential.class)).getCertificateChain());
                continue;
            }
            subject.getPublicCredentials().add(credential);
        }
        for (Credential credential : securityIdentity.getPrivateCredentials()) {
            if (credential instanceof PasswordCredential) {
                SubjectUtil.addPrivateCredential(subject, ((PasswordCredential)credential.castAs(PasswordCredential.class)).getPassword());
                continue;
            }
            if (credential instanceof SecretKeyCredential) {
                SubjectUtil.addPrivateCredential(subject, ((SecretKeyCredential)credential.castAs(SecretKeyCredential.class)).getSecretKey());
                continue;
            }
            if (credential instanceof KeyPairCredential) {
                SubjectUtil.addPrivateCredential(subject, ((KeyPairCredential)credential.castAs(KeyPairCredential.class)).getKeyPair());
                continue;
            }
            if (credential instanceof X509CertificateChainPrivateCredential) {
                SubjectUtil.addPrivateCredential(subject, ((X509CertificateChainPrivateCredential)credential.castAs(X509CertificateChainPrivateCredential.class)).getCertificateChain());
                continue;
            }
            SubjectUtil.addPrivateCredential(subject, credential);
        }
        SubjectUtil.addPrivateCredential(subject, securityIdentity);
        return subject;
    }

    private static void addPrivateCredential(Subject subject, Object credential) {
        if (!WildFlySecurityManager.isChecking()) {
            subject.getPrivateCredentials().add(credential);
        } else {
            AccessController.doPrivileged(() -> {
                subject.getPrivateCredentials().add(credential);
                return null;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public static SecurityIdentity convertToSecurityIdentity(Subject subject, Principal principal, SecurityDomain domain, String roleCategory) {
        void var6_11;
        SecurityIdentity identity = null;
        for (Object object : subject.getPrivateCredentials()) {
            if (!(object instanceof SecurityIdentity)) continue;
            identity = (SecurityIdentity)object;
            break;
        }
        if (identity == null) {
            identity = domain.createAdHocIdentity(principal);
        }
        if (groupClass != null) {
            HashSet<String> roles = new HashSet<String>();
            for (Principal prin : subject.getPrincipals()) {
                if (!groupClass.isInstance(prin) || !"Roles".equalsIgnoreCase(prin.getName())) continue;
                Enumeration enumeration = ((Group)prin).members();
                while (enumeration.hasMoreElements()) {
                    roles.add(((Principal)enumeration.nextElement()).getName());
                }
            }
            if (!roles.isEmpty()) {
                identity = identity.withRoleMapper(roleCategory, rolesToMap -> Roles.fromSet((Set)roles));
            }
        }
        IdentityCredentials publicCredentials = IdentityCredentials.NONE;
        for (Object credential : subject.getPublicCredentials()) {
            if (credential instanceof PublicKey) {
                publicCredentials = publicCredentials.withCredential((Credential)new PublicKeyCredential((PublicKey)credential));
                continue;
            }
            if (credential instanceof X509Certificate) {
                publicCredentials = publicCredentials.withCredential((Credential)new X509CertificateChainPublicCredential(new X509Certificate[]{(X509Certificate)credential}));
                continue;
            }
            if (!(credential instanceof Credential)) continue;
            publicCredentials = publicCredentials.withCredential((Credential)credential);
        }
        if (!publicCredentials.equals(IdentityCredentials.NONE)) {
            identity = identity.withPublicCredentials(publicCredentials);
        }
        IdentityCredentials identityCredentials = IdentityCredentials.NONE;
        for (Object credential : subject.getPrivateCredentials()) {
            if (credential instanceof Password) {
                IdentityCredentials identityCredentials2 = var6_11.withCredential((Credential)new PasswordCredential((Password)credential));
                continue;
            }
            if (credential instanceof SecretKey) {
                IdentityCredentials identityCredentials3 = var6_11.withCredential((Credential)new SecretKeyCredential((SecretKey)credential));
                continue;
            }
            if (credential instanceof KeyPair) {
                IdentityCredentials identityCredentials4 = var6_11.withCredential((Credential)new KeyPairCredential((KeyPair)credential));
                continue;
            }
            if (credential instanceof PrivateKey) {
                IdentityCredentials identityCredentials5 = var6_11.withCredential((Credential)new X509CertificateChainPrivateCredential((PrivateKey)credential, new X509Certificate[0]));
                continue;
            }
            if (!(credential instanceof Credential)) continue;
            IdentityCredentials identityCredentials6 = var6_11.withCredential((Credential)credential);
        }
        if (!var6_11.equals(IdentityCredentials.NONE)) {
            identity = identity.withPrivateCredentials((IdentityCredentials)var6_11);
        }
        return identity;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.security.acl.Group");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        groupClass = clazz;
    }
}

