/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.extensions;

import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import org.jboss.security.identity.IdentityFactory;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.extensions.CertificateIdentity;

public class CertificateIdentityFactory
extends IdentityFactory {
    private static CertificateIdentityFactory _instance = null;

    protected CertificateIdentityFactory() {
    }

    public static CertificateIdentityFactory getInstance() {
        if (_instance == null) {
            _instance = new CertificateIdentityFactory();
        }
        return _instance;
    }

    public CertificateIdentity createIdentity(final Principal principal, final X509Certificate[] certs, final Role roles) {
        return new CertificateIdentity(){
            private static final long serialVersionUID = 1L;

            @Override
            public X509Certificate[] getCredential() {
                return certs;
            }

            @Override
            public void setCredential(X509Certificate[] certs2) {
            }

            @Override
            public Group asGroup() {
                return null;
            }

            @Override
            public Principal asPrincipal() {
                return principal;
            }

            @Override
            public String getName() {
                return principal.getName();
            }

            @Override
            public Role getRole() {
                return roles;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("CertificateIdentity[").append(" Certs=").append(certs).append("]");
                return builder.toString();
            }
        };
    }
}

