/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers.principal;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.principal.AbstractPrincipalMappingProvider;

public class SubjectDNMapper
extends AbstractPrincipalMappingProvider {
    private MappingResult<Principal> result;

    @Override
    public void init(Map<String, Object> opt) {
    }

    @Override
    public void setMappingResult(MappingResult<Principal> res) {
        this.result = res;
    }

    @Override
    public void performMapping(Map<String, Object> contextMap, Principal principal) {
        if (contextMap == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("contextMap");
        }
        X509Certificate[] certs = (X509Certificate[])contextMap.get("X509");
        if (certs != null) {
            SubjectDNMapping sdn = new SubjectDNMapping();
            principal = sdn.toPrinicipal(certs);
            PicketBoxLogger.LOGGER.traceMappedX500Principal(principal);
        }
        this.result.setMappedObject(principal);
    }
}

