/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.common.Node;
import io.vertx.kafka.client.common.TopicPartitionInfo;
import java.util.ArrayList;
import java.util.Map;

public class TopicPartitionInfoConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, TopicPartitionInfo obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "isr": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Node> list = new ArrayList<Node>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Node((JsonObject)item));
                        }
                    });
                    obj.setIsr(list);
                    break;
                }
                case "leader": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setLeader(new Node((JsonObject)member.getValue()));
                    break;
                }
                case "partition": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPartition(((Number)member.getValue()).intValue());
                    break;
                }
                case "replicas": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Node> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Node((JsonObject)item));
                        }
                    });
                    obj.setReplicas(list);
                }
            }
        }
    }

    public static void toJson(TopicPartitionInfo obj, JsonObject json) {
        TopicPartitionInfoConverter.toJson(obj, json.getMap());
    }

    public static void toJson(TopicPartitionInfo obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getIsr() != null) {
            array = new JsonArray();
            obj.getIsr().forEach(item -> array.add((Object)item.toJson()));
            json.put("isr", array);
        }
        if (obj.getLeader() != null) {
            json.put("leader", obj.getLeader().toJson());
        }
        json.put("partition", obj.getPartition());
        if (obj.getReplicas() != null) {
            array = new JsonArray();
            obj.getReplicas().forEach(item -> array.add((Object)item.toJson()));
            json.put("replicas", array);
        }
    }
}

