/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.queues;

import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpscArrayQueue<E>
extends AtomicReferenceArray<E>
implements Queue<E> {
    private static final Integer MAX_LOOK_AHEAD_STEP = 4096;
    private final int mask;
    private final AtomicLong producerIndex = new AtomicLong();
    private long producerLookAhead;
    private final AtomicLong consumerIndex = new AtomicLong();
    private final int lookAheadStep;

    public SpscArrayQueue(int capacity) {
        super(SpscArrayQueue.roundToPowerOfTwo(capacity));
        this.mask = this.length() - 1;
        this.lookAheadStep = Math.min(capacity / 4, MAX_LOOK_AHEAD_STEP);
    }

    public static int roundToPowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        int mask = this.mask;
        long index = this.producerIndex.get();
        int offset = this.calcElementOffset(index, mask);
        if (index >= this.producerLookAhead) {
            int step = this.lookAheadStep;
            if (null == this.lvElement(this.calcElementOffset(index + (long)step, mask))) {
                this.producerLookAhead = index + (long)step;
            } else if (null != this.lvElement(offset)) {
                return false;
            }
        }
        this.soElement(offset, e);
        this.soProducerIndex(index + 1L);
        return true;
    }

    @Override
    public E poll() {
        long index = this.consumerIndex.get();
        int offset = this.calcElementOffset(index);
        E e = this.lvElement(offset);
        if (null == e) {
            return null;
        }
        this.soConsumerIndex(index + 1L);
        this.soElement(offset, null);
        return e;
    }

    @Override
    public int size() {
        long ci = this.consumerIndex.get();
        while (true) {
            long pi = this.producerIndex.get();
            long ci2 = this.consumerIndex.get();
            if (ci == ci2) {
                return (int)(pi - ci);
            }
            ci = ci2;
        }
    }

    @Override
    public E peek() {
        int offset = (int)this.consumerIndex.get() & this.mask;
        return this.get(offset);
    }

    @Override
    public boolean isEmpty() {
        return this.producerIndex.get() == this.consumerIndex.get();
    }

    void soProducerIndex(long newIndex) {
        this.producerIndex.lazySet(newIndex);
    }

    void soConsumerIndex(long newIndex) {
        this.consumerIndex.lazySet(newIndex);
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    int calcElementOffset(long index, int mask) {
        return (int)index & mask;
    }

    int calcElementOffset(long index) {
        return (int)index & this.mask;
    }

    void soElement(int offset, E value) {
        this.lazySet(offset, value);
    }

    E lvElement(int offset) {
        return this.get(offset);
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R> R[] toArray(R[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E element() {
        throw new UnsupportedOperationException();
    }
}

