/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class KeyStoreKeyRepository {
    private KeyStore keyStore;
    private String password;

    public void init(InputStream is, String password) {
        if (password != null) {
            password = password.trim();
        }
        this.password = password;
        try {
            this.keyStore = KeyStore.getInstance("JKS");
            this.keyStore.load(is, password.toCharArray());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public KeyStoreKeyRepository(InputStream is, String password) {
        this.init(is, password);
    }

    public KeyStoreKeyRepository(String filename, String password) throws IOException {
        FileInputStream is = new FileInputStream(filename);
        this.init(is, password);
        ((InputStream)is).close();
    }

    public PrivateKey getPrivateKey(Object identity) {
        try {
            Key key = this.keyStore.getKey(identity.toString(), this.password.toCharArray());
            return (PrivateKey)key;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public PublicKey getPublicKey(Object identity) {
        Certificate cert = null;
        try {
            cert = this.keyStore.getCertificate(identity.toString());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        if (cert == null) {
            return null;
        }
        return cert.getPublicKey();
    }
}

