/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.logging;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleLoadException;

@MessageLogger(projectCode="WFLYDC", length=4)
public interface DomainControllerLogger
extends BasicLogger {
    public static final DomainControllerLogger ROOT_LOGGER = (DomainControllerLogger)Logger.getMessageLogger(DomainControllerLogger.class, (String)"org.jboss.as.domain.controller");
    public static final DomainControllerLogger HOST_CONTROLLER_LOGGER = (DomainControllerLogger)Logger.getMessageLogger(DomainControllerLogger.class, (String)"org.jboss.as.host.controller");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Ignoring 'include' child of 'socket-binding-group' %s")
    public void warnIgnoringSocketBindingGroupInclude(Location var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Ignoring 'include' child of 'profile' %s")
    public void warnIgnoringProfileInclude(Location var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Interrupted awaiting final response from server %s on host %s; remote process has been notified to cancel operation")
    public void interruptedAwaitingFinalResponse(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Caught exception awaiting final response from server %s on host %s")
    public void caughtExceptionAwaitingFinalResponse(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5, value="Interrupted awaiting final response from host %s; remote process has been notified to cancel operation")
    public void interruptedAwaitingFinalResponse(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Caught exception awaiting final response from host %s")
    public void caughtExceptionAwaitingFinalResponse(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Caught exception closing input stream")
    public void caughtExceptionClosingInputStream(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=8, value="Domain model has changed on re-connect. The following servers will need to be restarted for changes to take affect: %s")
    public void domainModelChangedOnReConnect(Set<ServerIdentity> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=9, value="%s caught %s waiting for task %s. Cancelling task")
    public void caughtExceptionWaitingForTask(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11, value="No deployment content with hash %s is available in the deployment content repository for deployment %s. Because this Host Controller is booting in ADMIN-ONLY mode, boot will be allowed to proceed to provide administrators an opportunity to correct this problem. If this Host Controller were not in ADMIN-ONLY mode this would be a fatal boot failure.")
    public void reportAdminOnlyMissingDeploymentContent(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="failed to set server (%s) into a restart required state")
    public void failedToSetServerInRestartRequireState(String var1);

    @Message(id=13, value="Registration of remote hosts is not supported on slave host controllers")
    public String slaveControllerCannotAcceptOtherSlaves();

    @Message(id=14, value="The master host controller cannot register slave host controllers as it's current running mode is '%s'")
    public String adminOnlyModeCannotAcceptSlaves(RunningMode var1);

    @Message(id=15, value="There is already a registered host named '%s'")
    public String slaveAlreadyRegistered(String var1);

    @Message(id=16, value="%s is missing %s: %s")
    public String requiredChildIsMissing(String var1, String var2, String var3);

    @Message(id=17, value="%s recognizes only %s as children: %s")
    public String unrecognizedChildren(String var1, String var2, String var3);

    @Message(id=18, value="in-series is missing groups: %s")
    public String inSeriesIsMissingGroups(String var1);

    @Message(id=19, value="server-group expects one and only one child: %s")
    public String serverGroupExpectsSingleChild(String var1);

    @Message(id=20, value="One of the groups does not define neither server-group nor concurrent-groups: %s")
    public String unexpectedInSeriesGroup(String var1);

    @Message(id=21, value="Unexplained failure")
    public String unexplainedFailure();

    @Message(id=22, value="Operation failed or was rolled back on all servers.")
    public String operationFailedOrRolledBack();

    @Message(id=23, value="Interrupted waiting for result from server %s")
    public String interruptedAwaitingResultFromServer(ServerIdentity var1);

    @Message(id=24, value="Exception getting result from server %s: %s")
    public String exceptionAwaitingResultFromServer(ServerIdentity var1, String var2);

    @Message(id=25, value="Invalid rollout plan. %s is not a valid child of node %s")
    public String invalidRolloutPlan(ModelNode var1, String var2);

    @Message(id=26, value="Invalid rollout plan. Plan operations affect server groups %s that are not reflected in the rollout plan")
    public String invalidRolloutPlan(Set<String> var1);

    @Message(id=27, value="Invalid rollout plan. Server group %s appears more than once in the plan.")
    public String invalidRolloutPlanGroupAlreadyExists(String var1);

    @Message(id=28, value="Invalid rollout plan. Server group %s has a %s value of %s; must be between 0 and 100.")
    public String invalidRolloutPlanRange(String var1, String var2, int var3);

    @Message(id=29, value="Invalid rollout plan. Server group %s has a %s value of %s; cannot be less than 0.")
    public String invalidRolloutPlanLess(String var1, String var2, int var3);

    @Message(id=30, value="Interrupted waiting for result from host %s")
    public String interruptedAwaitingResultFromHost(String var1);

    @Message(id=32, value="Operation %s for address %s can only be handled by the master Domain Controller; this host is not the master Domain Controller")
    public String masterDomainControllerOnlyOperation(String var1, PathAddress var2);

    @Message(id=33, value="Operation targets host %s but that host is not registered")
    public OperationFailedException invalidOperationTargetHost(String var1);

    @Message(id=34, value="Caught %s storing deployment content -- %s")
    public OperationFailedException caughtExceptionStoringDeploymentContent(String var1, Throwable var2);

    @Message(id=35, value="Unexpected initial path key %s")
    public IllegalStateException unexpectedInitialPathKey(String var1);

    @Message(id=36, value="Null stream at index %d")
    public String nullStream(int var1);

    @Message(id=37, value="Invalid byte stream.")
    public String invalidByteStream();

    @Message(id=38, value="Invalid url stream.")
    public String invalidUrlStream();

    @Message(id=39, value="Only 1 piece of content is currently supported (AS7-431)")
    public String as7431();

    @Message(id=40, value="No deployment content with hash %s is available in the deployment content repository.")
    public String noDeploymentContentWithHash(String var1);

    @Message(id=41, value="A slave domain controller cannot accept deployment content uploads")
    public String slaveCannotAcceptUploads();

    @Message(id=42, value="No deployment with name %s found")
    public String noDeploymentContentWithName(String var1);

    @Message(id=43, value="Cannot remove deployment %s from the domain as it is still used by server groups %s")
    public String cannotRemoveDeploymentInUse(String var1, List<String> var2);

    @Message(id=44, value="Invalid '%s' value: %d, the maximum index is %d")
    public String invalidValue(String var1, int var2, int var3);

    @Message(id=45, value="%s is not a valid URL -- %s")
    public String invalidUrl(String var1, String var2);

    @Message(id=46, value="Error obtaining input stream from URL %s -- %s")
    public String errorObtainingUrlStream(String var1, String var2);

    @Message(id=47, value="Invalid content declaration")
    public String invalidContentDeclaration();

    @Message(id=49, value="Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.")
    public String cannotUseSameValueForParameters(String var1, String var2, String var3, String var4, String var5);

    @Message(id=50, value="Deployment %s is already started")
    public String deploymentAlreadyStarted(String var1);

    @Message(id=51, value="Unknown %s %s")
    public String unknown(String var1, String var2);

    @Message(id=52, value="Unknown server group %s")
    public IllegalStateException unknownServerGroup(String var1);

    @Message(id=53, value="Unknown server %s")
    public IllegalStateException unknownServer(ServerIdentity var1);

    @Message(id=54, value="Invalid code %d")
    public IllegalArgumentException invalidCode(int var1);

    @Message(id=55, value="Repository does not contain any deployment with hash %s")
    public IllegalStateException deploymentHashNotFoundInRepository(String var1);

    @Message(id=56, value="Expected only one deployment, found %d")
    public IllegalStateException expectedOnlyOneDeployment(int var1);

    @Message(id=57, value="No profile called: %s")
    public OperationFailedException noProfileCalled(String var1);

    @Message(id=58, value="No deployment content with hash %s is available in the deployment content repository for deployment '%s'. This is a fatal boot error. To correct the problem, either restart with the --admin-only switch set and use the CLI to install the missing content or remove it from the configuration, or remove the deployment from the xml configuraiton file and restart.")
    public String noDeploymentContentWithHashAtBoot(String var1, String var2);

    @Message(id=59, value="Failed to load module '%s'.")
    public OperationFailedException failedToLoadModule(@Cause ModuleLoadException var1, String var2);

    @Message(id=60, value="Invalid Jakarta Server Faces slot value: '%s'. The host controller is not able to use a Jakarta Server Faces slot value different from its default. This resource will be ignored on that host")
    public String invalidJSFSlotValue(String var1);

    @Message(id=61, value="Operation '%s' fails because the attributes are not known from the subsytem '%s' model version '%s': %s")
    public String unknownAttributesFromSubsystemVersion(String var1, String var2, ModelVersion var3, Collection<String> var4);

    @Message(id=62, value="No socket-binding-group named: %s")
    public OperationFailedException noSocketBindingGroupCalled(String var1);

    @Message(id=63, value="There is already a deployment called %s with the same runtime name %s on server group %s")
    public OperationFailedException runtimeNameMustBeUnique(String var1, String var2, String var3);

    @Message(id=64, value="Cannot remove server-group '%s' since it's still in use by servers %s")
    public OperationFailedException cannotRemoveUsedServerGroup(String var1, Set<String> var2);

    @Message(id=65, value="Wildcard operations are not supported as part of composite operations")
    public OperationFailedException unsupportedWildcardOperation();

    @Message(id=66, value="Failed to send message: %s")
    public String failedToSendMessage(String var1);

    @Message(id=67, value="Failed to send response header: %s")
    public String failedToSendResponseHeader(String var1);

    @Message(id=68, value="Host registration task got interrupted")
    public String registrationTaskGotInterrupted();

    @Message(id=69, value="Host registration task failed: %s")
    public String registrationTaskFailed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=70, value="%s interrupted awaiting server prepared response(s) -- cancelling updates for servers %s")
    public void interruptedAwaitingPreparedResponse(String var1, Set<ServerIdentity> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=71, value="Interrupted awaiting host prepared response(s) -- cancelling updates for hosts %s")
    public void interruptedAwaitingHostPreparedResponse(Set<String> var1);

    @Message(id=72, value="Caught IOException reading uploaded deployment content")
    public OperationFailedException caughtIOExceptionUploadingContent(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=73, value="%s deployment has been re-deployed, its content will not be removed. You will need to restart it.")
    public void undeployingDeploymentHasBeenRedeployed(String var1);

    @Message(id=74, value="Operation failed or was rolled back on all servers. Server failures:")
    public String operationFailedOrRolledBackWithCause();

    @Message(id=75, value="Cannot synchronize the model due to missing extensions: %s")
    public OperationFailedException missingExtensions(Set<String> var1);

    @Message(id=76, value="Duplicate included profile '%s'")
    public XMLStreamException duplicateProfileInclude(String var1);

    @Message(id=77, value="Duplicate included socket binding group '%s'")
    public XMLStreamException duplicateSocketBindingGroupInclude(String var1);

    @Message(id=78, value="The profile clone operation is not available on the host '%s'. To be able to use it in a domain containing older slaves which do not support the profile clone operation, you need to either: a) Make sure that all older slaves with a model version smaller than 4.0.0 ignore the cloned profile and the profile specified in the 'to-profile' parameter. b) Reload the domain controller into admin-only mode, perform the clone, then reload the domain controller into normal mode again, and check whether the slaves need reloading.")
    public String cloneOperationNotSupportedOnHost(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=79, value="Timed out after %d ms awaiting host prepared response(s) from hosts %s -- cancelling updates for hosts %s")
    public void timedOutAwaitingHostPreparedResponses(long var1, Set<String> var3, Set<String> var4);

    @Message(id=80, value="Timed out after %d ms awaiting host prepared response(s) -- remote host %s has been notified to cancel operation")
    public String timedOutAwaitingHostPreparedResponse(long var1, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=81, value="Timed out after %d ms awaiting final response from host %s; remote process has been notified to cancel operation")
    public void timedOutAwaitingFinalResponse(long var1, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=82, value="%s timed out after %d ms awaiting server prepared response(s) -- cancelling updates for servers %s")
    public void timedOutAwaitingPreparedResponse(String var1, long var2, Set<ServerIdentity> var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=83, value="Timed out after %d ms awaiting final response from server %s on host %s; remote process has been notified to cancel operation")
    public void timedOutAwaitingFinalResponse(int var1, String var2, String var3);

    @Message(id=84, value="Cannot explode a deployment in a self-contained server")
    public OperationFailedException cannotExplodeDeploymentOfSelfContainedServer();

    @Message(id=85, value="Cannot explode an unmanaged deployment")
    public OperationFailedException cannotExplodeUnmanagedDeployment();

    @Message(id=86, value="Cannot explode an already exploded deployment")
    public OperationFailedException cannotExplodeAlreadyExplodedDeployment();

    @Message(id=87, value="Cannot explode an already deployed deployment")
    public OperationFailedException cannotExplodeEnabledDeployment();

    @Message(id=88, value="Cannot add content to a deployment in a self-contained server")
    public OperationFailedException cannotAddContentToSelfContainedServer();

    @Message(id=89, value="Cannot add content to an unmanaged deployment")
    public OperationFailedException cannotAddContentToUnmanagedDeployment();

    @Message(id=90, value="Cannot add content to an unexploded deployment")
    public OperationFailedException cannotAddContentToUnexplodedDeployment();

    @Message(id=91, value="Cannot remove content from a deployment in a self-contained server")
    public OperationFailedException cannotRemoveContentFromSelfContainedServer();

    @Message(id=92, value="Cannot remove content from an unmanaged deployment")
    public OperationFailedException cannotRemoveContentFromUnmanagedDeployment();

    @Message(id=93, value="Cannot remove content from an unexploded deployment")
    public OperationFailedException cannotRemoveContentFromUnexplodedDeployment();

    @Message(id=94, value="Cannot read content from a deployment in a self-contained server")
    public OperationFailedException cannotReadContentFromSelfContainedServer();

    @Message(id=95, value="Cannot read content from an unmanaged deployment")
    public OperationFailedException cannotReadContentFromUnmanagedDeployment();

    @Message(id=96, value="Cannot read content from an unexploded deployment")
    public OperationFailedException cannotReadContentFromUnexplodedDeployment();

    @Message(id=97, value="Cannot explode a subdeployment of an unexploded deployment")
    public OperationFailedException cannotExplodeSubDeploymentOfUnexplodedDeployment();

    @Message(id=98, value="The following servers %s are starting; execution of remote management operations is not currently available")
    public OperationFailedException serverManagementUnavailableDuringBoot(String var1);
}

