/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.resources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;

public class ServerConfigResource
extends DelegatingResource {
    private final ServerInventory serverInventory;
    private final String serverName;
    private final ControlledProcessState processState;
    private final Path autoStartDataDir;
    private static final String STOPPED_EXT = ".stopped";
    private static final String STARTED_EXT = ".started";

    public ServerConfigResource(ServerInventory serverInventory, ControlledProcessState processState, String serverName, File domainDataDir, Resource delegate) {
        super(delegate);
        this.serverInventory = serverInventory;
        this.serverName = serverName;
        this.processState = processState;
        this.autoStartDataDir = domainDataDir.toPath().resolve("auto-start");
        try {
            if (Files.notExists(this.autoStartDataDir, new LinkOption[0])) {
                Files.createDirectory(this.autoStartDataDir, new FileAttribute[0]);
            }
        }
        catch (IOException ex) {
            throw HostControllerLogger.ROOT_LOGGER.couldNotCreateDomainAutoStartDirectory(this.autoStartDataDir, ex);
        }
    }

    public ModelNode getModel() {
        assert (this.serverName != null && !this.serverName.isEmpty()) : "ServerName is null";
        ModelNode model = super.getModel();
        if (this.processState.getState() == ControlledProcessState.State.STARTING) {
            this.getAutoStart(this.serverName, model);
        } else if (this.processState.getState() == ControlledProcessState.State.RUNNING) {
            this.persistAutoStart(this.serverName, model);
        }
        return model;
    }

    private void getAutoStart(String serverName, ModelNode model) {
        Path startedFile = this.autoStartDataDir.resolve(serverName + STARTED_EXT);
        Path stoppedFile = this.autoStartDataDir.resolve(serverName + STOPPED_EXT);
        if (this.shouldUpdateAutoStart(model)) {
            if (Files.exists(startedFile, new LinkOption[0])) {
                model.get("auto-start").set(true);
            }
            if (Files.exists(stoppedFile, new LinkOption[0])) {
                model.get("auto-start").set(false);
            }
        }
    }

    private void persistAutoStart(String serverName, ModelNode model) {
        Path startedFile = this.autoStartDataDir.resolve(serverName + STARTED_EXT);
        Path stoppedFile = this.autoStartDataDir.resolve(serverName + STOPPED_EXT);
        if (this.serverInventory != null && this.shouldUpdateAutoStart(model)) {
            ServerStatus status = this.serverInventory.determineServerStatus(serverName);
            try {
                if (status == ServerStatus.STARTED || status == ServerStatus.STARTING) {
                    if (Files.notExists(startedFile, new LinkOption[0])) {
                        Files.createFile(startedFile, new FileAttribute[0]);
                    }
                    Files.deleteIfExists(stoppedFile);
                    model.get("auto-start").set(true);
                } else if (status == ServerStatus.STOPPED || status == ServerStatus.STOPPING) {
                    if (Files.notExists(stoppedFile, new LinkOption[0])) {
                        Files.createFile(stoppedFile, new FileAttribute[0]);
                    }
                    Files.deleteIfExists(startedFile);
                    model.get("auto-start").set(false);
                }
            }
            catch (IOException ex) {
                HostControllerLogger.ROOT_LOGGER.couldNotPersistAutoStartServerStatus(ex);
            }
        }
    }

    private boolean shouldUpdateAutoStart(ModelNode model) {
        return model.hasDefined("update-auto-start-with-server-status") && model.get("update-auto-start-with-server-status").asBoolean();
    }

    public Resource clone() {
        Resource delegate = super.clone();
        return new ServerConfigResource(this.serverInventory, this.processState, this.serverName, this.autoStartDataDir.getParent().toFile(), delegate);
    }
}

