/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.file;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.streams.WriteStream;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.core.file.AsyncFile.class)
public class AsyncFile
implements ReadStream<Buffer>,
io.vertx.mutiny.core.streams.WriteStream<Buffer> {
    public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg(obj -> new AsyncFile((io.vertx.core.file.AsyncFile)obj), AsyncFile::getDelegate);
    private final io.vertx.core.file.AsyncFile delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private WriteStreamSubscriber<Buffer> subscriber;
    private Multi<Buffer> multi;

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    public AsyncFile(Object delegate) {
        this.delegate = (io.vertx.core.file.AsyncFile)delegate;
    }

    AsyncFile() {
        this.delegate = null;
    }

    public io.vertx.core.file.AsyncFile getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFile that = (AsyncFile)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber((WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Uni<Void> write(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.write((Object)data.getDelegate(), handler));
    }

    @Override
    public Void writeAndAwait(Buffer data) {
        return (Void)this.write(data).await().indefinitely();
    }

    @Override
    public void writeAndForget(Buffer data) {
        this.write(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end(handler));
    }

    @Override
    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    @Override
    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @Override
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.end((Object)data.getDelegate(), handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return (Void)this.end(data).await().indefinitely();
    }

    @Override
    public void endAndForget(Buffer data) {
        this.end(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private AsyncFile __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle((Object)Buffer.newInstance(event));
            }
        });
        return this;
    }

    public AsyncFile handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    @Fluent
    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    private AsyncFile __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public AsyncFile endHandler(Runnable endHandler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> endHandler.run()));
    }

    @Fluent
    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Fluent
    private AsyncFile __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public AsyncFile drainHandler(Runnable handler) {
        return this.__drainHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    private AsyncFile __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    public AsyncFile fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public Uni<Void> write(Buffer buffer, long position) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(buffer.getDelegate(), position, handler));
    }

    public Void writeAndAwait(Buffer buffer, long position) {
        return (Void)this.write(buffer, position).await().indefinitely();
    }

    public void writeAndForget(Buffer buffer, long position) {
        this.write(buffer, position).subscribe().with(UniHelper.NOOP);
    }

    public Uni<Buffer> read(Buffer buffer, int offset, long position, int length) {
        return AsyncResultUni.toUni(handler -> this.delegate.read(buffer.getDelegate(), offset, position, length, (Handler)new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Buffer.newInstance((io.vertx.core.buffer.Buffer)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Buffer readAndAwait(Buffer buffer, int offset, long position, int length) {
        return (Buffer)this.read(buffer, offset, position, length).await().indefinitely();
    }

    @Fluent
    public AsyncFile readAndForget(Buffer buffer, int offset, long position, int length) {
        this.read(buffer, offset, position, length).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> flush() {
        return AsyncResultUni.toUni(handler -> this.delegate.flush(handler));
    }

    public Void flushAndAwait() {
        return (Void)this.flush().await().indefinitely();
    }

    @Fluent
    public AsyncFile flushAndForget() {
        this.flush().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    @Fluent
    public AsyncFile setReadLength(long readLength) {
        this.delegate.setReadLength(readLength);
        return this;
    }

    public long getReadLength() {
        long ret = this.delegate.getReadLength();
        return ret;
    }

    @Fluent
    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public long getWritePos() {
        long ret = this.delegate.getWritePos();
        return ret;
    }

    @Fluent
    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    @Override
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

