/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.Context;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.Server;
import org.jboss.modcluster.mcmp.ContextFilter;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.ResetRequestSource;

public class ResetRequestSourceImpl
implements ResetRequestSource {
    private final NodeConfiguration nodeConfig;
    private final BalancerConfiguration balancerConfig;
    private final MCMPRequestFactory requestFactory;
    private volatile ContextFilter contextFilter;
    private volatile Server server;

    public ResetRequestSourceImpl(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPRequestFactory requestFactory) {
        this.nodeConfig = nodeConfig;
        this.balancerConfig = balancerConfig;
        this.requestFactory = requestFactory;
    }

    @Override
    public void init(Server server, ContextFilter contextFilter) {
        this.contextFilter = contextFilter;
        this.server = server;
    }

    @Override
    public List<MCMPRequest> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> response) {
        ArrayList<MCMPRequest> requests = new ArrayList<MCMPRequest>();
        if (this.server == null) {
            return requests;
        }
        boolean contextAutoEnableAllowed = this.contextFilter.isAutoEnableContexts();
        LinkedList<MCMPRequest> engineRequests = new LinkedList<MCMPRequest>();
        for (Engine engine : this.server.getEngines()) {
            Connector connector = engine.getProxyConnector();
            if (connector == null) continue;
            engineRequests.add(this.requestFactory.createConfigRequest(engine, this.nodeConfig, this.balancerConfig));
            String jvmRoute = engine.getJvmRoute();
            Set<ResetRequestSource.VirtualHost> responseHosts = response.containsKey(jvmRoute) ? response.get(jvmRoute) : Collections.emptySet();
            for (Host host : engine.getHosts()) {
                String hostName = host.getName();
                Set aliases = host.getAliases();
                ResetRequestSource.VirtualHost responseHost = null;
                for (ResetRequestSource.VirtualHost virtualHost : responseHosts) {
                    if (!virtualHost.getAliases().contains(hostName)) continue;
                    responseHost = virtualHost;
                    break;
                }
                Set<String> responseAliases = Collections.emptySet();
                Map<Object, Object> responseContexts = Collections.emptyMap();
                if (responseHost != null) {
                    responseAliases = responseHost.getAliases();
                    responseContexts = responseHost.getContexts();
                    if (!aliases.equals(responseAliases)) {
                        engineRequests.add(0, this.requestFactory.createRemoveRequest(engine));
                    }
                }
                HashSet obsoleteContexts = new HashSet(responseContexts.keySet());
                Set<String> excludedHostContexts = this.contextFilter.getExcludedContexts(host);
                for (Object context : host.getContexts()) {
                    String contextPath = context.getPath();
                    if (excludedHostContexts != null && excludedHostContexts.contains(contextPath)) continue;
                    String path = contextPath.length() == 0 ? "/" : contextPath;
                    obsoleteContexts.remove(path);
                    ResetRequestSource.Status status = (ResetRequestSource.Status)((Object)responseContexts.get(path));
                    if (context.isStarted()) {
                        if (status == ResetRequestSource.Status.ENABLED) continue;
                        engineRequests.add(contextAutoEnableAllowed ? this.requestFactory.createEnableRequest((Context)context) : this.requestFactory.createDisableRequest((Context)context));
                        continue;
                    }
                    if (status != ResetRequestSource.Status.ENABLED) continue;
                    engineRequests.add(this.requestFactory.createStopRequest((Context)context));
                }
                if (obsoleteContexts.isEmpty()) continue;
                if (obsoleteContexts.size() == responseContexts.size()) {
                    engineRequests.add(0, this.requestFactory.createRemoveRequest(engine));
                    continue;
                }
                for (Object context : obsoleteContexts) {
                    engineRequests.add(0, this.requestFactory.createRemoveContextRequest(jvmRoute, responseAliases, (String)context));
                }
            }
            requests.addAll(engineRequests);
            engineRequests.clear();
        }
        return requests;
    }
}

