/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.health.HealthReporter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class HealthCenter {
    @Inject
    @Any
    Instance<HealthReporter> reporters;
    List<ReportedFailure> failures = new CopyOnWriteArrayList<ReportedFailure>();

    public HealthReport getReadiness() {
        HealthReport.HealthReportBuilder builder = HealthReport.builder();
        this.reporters.forEach(r -> r.getReadiness().getChannels().forEach(arg_0 -> ((HealthReport.HealthReportBuilder)builder).add(arg_0)));
        this.failures.forEach(rf -> builder.add(rf.source, false, rf.failure.getMessage()));
        return builder.build();
    }

    public HealthReport getLiveness() {
        HealthReport.HealthReportBuilder builder = HealthReport.builder();
        this.reporters.forEach(r -> r.getLiveness().getChannels().forEach(arg_0 -> ((HealthReport.HealthReportBuilder)builder).add(arg_0)));
        this.failures.forEach(rf -> builder.add(rf.source, false, rf.failure.getMessage()));
        return builder.build();
    }

    public void report(String source, Throwable cause) {
        this.failures.add(new ReportedFailure(source, cause));
    }

    public void reportApplicationFailure(String method, Throwable cause) {
        this.failures.add(new ReportedFailure("application-" + method, cause));
    }

    public static class ReportedFailure {
        final String source;
        final Throwable failure;

        public ReportedFailure(String source, Throwable failure) {
            this.source = source;
            this.failure = failure;
        }
    }
}

