/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.metrics;

import io.smallrye.reactive.messaging.PublisherDecorator;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;

@ApplicationScoped
public class MetricDecorator
implements PublisherDecorator {
    private MetricRegistry registry;

    @Inject
    private void setMetricRegistry(@RegistryType(type=MetricRegistry.Type.BASE) Instance<MetricRegistry> registryInstance) {
        if (registryInstance.isResolvable()) {
            this.registry = (MetricRegistry)registryInstance.get();
        }
    }

    @Override
    public PublisherBuilder<? extends Message<?>> decorate(PublisherBuilder<? extends Message<?>> publisher, String channelName) {
        if (this.registry != null) {
            return publisher.peek(this.incrementCount(channelName));
        }
        return publisher;
    }

    private Consumer<Message<?>> incrementCount(String channelName) {
        Counter counter = this.registry.counter("mp.messaging.message.count", new Tag[]{new Tag("channel", channelName)});
        return m -> counter.inc();
    }
}

