/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.spi;

import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public interface Stage {

    public static interface Coupled
    extends Stage {
        public Graph getSubscriber();

        public Graph getPublisher();
    }

    public static interface FromCompletionStageNullable
    extends Stage {
        public CompletionStage<?> getCompletionStage();
    }

    public static interface FromCompletionStage
    extends Stage {
        public CompletionStage<?> getCompletionStage();
    }

    public static interface Cancel
    extends Stage {
    }

    public static interface Concat
    extends Stage {
        public Graph getFirst();

        public Graph getSecond();
    }

    public static interface Failed
    extends Stage {
        public Throwable getError();
    }

    public static interface OnErrorResumeWith
    extends Stage {
        public Function<Throwable, Graph> getFunction();
    }

    public static interface OnErrorResume
    extends Stage {
        public Function<Throwable, ?> getFunction();
    }

    public static interface OnComplete
    extends Stage {
        public Runnable getAction();
    }

    public static interface OnTerminate
    extends Stage {
        public Runnable getAction();
    }

    public static interface OnError
    extends Stage {
        public Consumer<Throwable> getConsumer();
    }

    public static interface FlatMapIterable
    extends Stage {
        public Function<?, Iterable<?>> getMapper();
    }

    public static interface FlatMapCompletionStage
    extends Stage {
        public Function<?, CompletionStage<?>> getMapper();
    }

    public static interface FlatMap
    extends Stage {
        public Function<?, Graph> getMapper();
    }

    public static interface Collect
    extends Stage {
        public Collector<?, ?, ?> getCollector();
    }

    public static interface SubscriberStage
    extends Stage {
        public Subscriber<?> getRsSubscriber();
    }

    public static interface FindFirst
    extends Stage {
    }

    public static interface ProcessorStage
    extends Stage {
        public Processor<?, ?> getRsProcessor();
    }

    public static interface Of
    extends Stage {
        public Iterable<?> getElements();
    }

    public static interface PublisherStage
    extends Stage {
        public Publisher<?> getRsPublisher();
    }

    public static interface TakeWhile
    extends Stage {
        public Predicate<?> getPredicate();
    }

    public static interface Distinct
    extends Stage {
    }

    public static interface Limit
    extends Stage {
        public long getLimit();
    }

    public static interface Skip
    extends Stage {
        public long getSkip();
    }

    public static interface DropWhile
    extends Stage {
        public Predicate<?> getPredicate();
    }

    public static interface Filter
    extends Stage {
        public Predicate<?> getPredicate();
    }

    public static interface Peek
    extends Stage {
        public Consumer<?> getConsumer();
    }

    public static interface Map
    extends Stage {
        public Function<?, ?> getMapper();
    }
}

