/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.registry;

import java.util.Collections;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.ee.CompositeIterable;
import org.wildfly.clustering.registry.RegistryFactory;
import org.wildfly.clustering.server.CacheCapabilityServiceConfiguratorFactory;
import org.wildfly.clustering.server.CacheJndiNameFactory;
import org.wildfly.clustering.server.CacheRequirementServiceConfiguratorProvider;
import org.wildfly.clustering.server.registry.RegistryServiceConfigurator;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;

public class RegistryFactoryServiceConfiguratorProvider
extends CacheRequirementServiceConfiguratorProvider<RegistryFactory<Object, Object>> {
    protected RegistryFactoryServiceConfiguratorProvider(CacheCapabilityServiceConfiguratorFactory<RegistryFactory<Object, Object>> factory) {
        super(ClusteringCacheRequirement.REGISTRY_FACTORY, factory, CacheJndiNameFactory.REGISTRY_FACTORY);
    }

    @Override
    public Iterable<CapabilityServiceConfigurator> getServiceConfigurators(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String cacheName) {
        Iterable<CapabilityServiceConfigurator> configurators = super.getServiceConfigurators(registry, containerName, cacheName);
        ServiceName registryServiceName = registry.getServiceName((Requirement)ClusteringCacheRequirement.REGISTRY);
        if (registryServiceName == null) {
            return configurators;
        }
        RegistryServiceConfigurator configurator = new RegistryServiceConfigurator(registryServiceName, containerName, cacheName);
        return new CompositeIterable(new Iterable[]{configurators, Collections.singleton(configurator)});
    }
}

