/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.ConcurrentManager;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.hotrod.tx.HotRodBatcher;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.ConcurrentSessionManager;
import org.wildfly.clustering.web.cache.session.MarshalledValueSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManager;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaDataFactory;
import org.wildfly.clustering.web.hotrod.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class HotRodSessionManagerFactory<S, SC, AL, MC, LC>
implements SessionManagerFactory<SC, LC, TransactionBatch> {
    private final Registrar<SessionExpirationListener> expirationRegistrar;
    private final Batcher<TransactionBatch> batcher;
    private final Duration transactionTimeout;
    private final SessionFactory<SC, CompositeSessionMetaDataEntry<LC>, ?, LC> factory;

    public HotRodSessionManagerFactory(HotRodSessionManagerFactoryConfiguration<S, SC, AL, MC, LC> config) {
        HotRodSessionMetaDataFactory metaDataFactory = new HotRodSessionMetaDataFactory(config);
        HotRodSessionFactory sessionFactory = new HotRodSessionFactory(config, metaDataFactory, this.createSessionAttributesFactory(config), config.getLocalContextFactory());
        this.factory = sessionFactory;
        this.expirationRegistrar = sessionFactory;
        this.batcher = new HotRodBatcher(config.getCache());
        this.transactionTimeout = Duration.ofMillis(config.getCache().getRemoteCacheManager().getConfiguration().transactionTimeout());
    }

    public SessionManager<LC, TransactionBatch> createSessionManager(final SessionManagerConfiguration<SC> configuration) {
        final Registrar<SessionExpirationListener> expirationRegistrar = this.expirationRegistrar;
        final Batcher<TransactionBatch> batcher = this.batcher;
        final Duration transactionTimeout = this.transactionTimeout;
        HotRodSessionManagerConfiguration config = new HotRodSessionManagerConfiguration<SC>(){

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public Registrar<SessionExpirationListener> getExpirationRegistrar() {
                return expirationRegistrar;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return configuration.getIdentifierFactory();
            }

            @Override
            public SC getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return batcher;
            }

            @Override
            public Duration getStopTimeout() {
                return transactionTimeout;
            }
        };
        return new ConcurrentSessionManager(new HotRodSessionManager(this.factory, config), ConcurrentManager::new);
    }

    public void close() {
        this.factory.close();
    }

    private SessionAttributesFactory<SC, ?> createSessionAttributesFactory(HotRodSessionManagerFactoryConfiguration<S, SC, AL, MC, LC> configuration) {
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory(new HotRodMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(new HotRodMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
        }
        throw new IllegalStateException();
    }

    private static class HotRodMarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, MC, LC>
    extends MarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, MC, LC>
    implements HotRodSessionAttributesFactoryConfiguration<S, SC, AL, V, MarshalledValue<V, MC>> {
        private final HotRodSessionManagerFactoryConfiguration<S, SC, AL, MC, LC> configuration;

        HotRodMarshalledValueSessionAttributesFactoryConfiguration(HotRodSessionManagerFactoryConfiguration<S, SC, AL, MC, LC> configuration) {
            super(configuration);
            this.configuration = configuration;
        }

        @Override
        public <CK, CV> RemoteCache<CK, CV> getCache() {
            return this.configuration.getCache();
        }
    }
}

