/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.client.channel.ChannelSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.PtyChannelConfiguration;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.channel.PtyChannelConfigurationMutator;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.core.CoreModuleProperties;

public class PtyCapableChannelSession
extends ChannelSession
implements PtyChannelConfigurationMutator {
    private boolean agentForwarding;
    private boolean usePty;
    private final Map<String, Object> env = new LinkedHashMap<String, Object>();
    private final PtyChannelConfiguration config;

    public PtyCapableChannelSession(boolean usePty, PtyChannelConfigurationHolder configHolder, Map<String, ?> env) {
        this.usePty = usePty;
        this.config = (PtyChannelConfiguration)PtyChannelConfigurationMutator.copyConfiguration((PtyChannelConfigurationHolder)configHolder, (PtyChannelConfigurationMutator)new PtyChannelConfiguration());
        this.config.setPtyType(this.resolvePtyType((PtyChannelConfigurationHolder)this.config));
        if (GenericUtils.isNotEmpty(env)) {
            for (Map.Entry<String, ?> ee : env.entrySet()) {
                this.setEnv(ee.getKey(), ee.getValue());
            }
        }
    }

    protected String resolvePtyType(PtyChannelConfigurationHolder configHolder) {
        String ptyType = configHolder.getPtyType();
        if (GenericUtils.isNotEmpty((CharSequence)ptyType)) {
            return ptyType;
        }
        ptyType = System.getenv("TERM");
        if (GenericUtils.isNotEmpty((CharSequence)ptyType)) {
            return ptyType;
        }
        return "dummy";
    }

    public void setupSensibleDefaultPty() {
        try {
            PtyChannelConfigurationMutator.setupSensitiveDefaultPtyConfiguration((PtyChannelConfigurationMutator)this);
        }
        catch (Throwable t) {
            this.debug("setupSensibleDefaultPty({}) Failed ({}) to setup: {}", this, t.getClass().getSimpleName(), t.getMessage(), t);
        }
    }

    public boolean isAgentForwarding() {
        return this.agentForwarding;
    }

    public void setAgentForwarding(boolean agentForwarding) {
        this.agentForwarding = agentForwarding;
    }

    public boolean isUsePty() {
        return this.usePty;
    }

    public void setUsePty(boolean usePty) {
        this.usePty = usePty;
    }

    public String getPtyType() {
        return this.config.getPtyType();
    }

    public void setPtyType(String ptyType) {
        this.config.setPtyType(ptyType);
    }

    public int getPtyColumns() {
        return this.config.getPtyColumns();
    }

    public void setPtyColumns(int ptyColumns) {
        this.config.setPtyColumns(ptyColumns);
    }

    public int getPtyLines() {
        return this.config.getPtyLines();
    }

    public void setPtyLines(int ptyLines) {
        this.config.setPtyLines(ptyLines);
    }

    public int getPtyWidth() {
        return this.config.getPtyWidth();
    }

    public void setPtyWidth(int ptyWidth) {
        this.config.setPtyWidth(ptyWidth);
    }

    public int getPtyHeight() {
        return this.config.getPtyHeight();
    }

    public void setPtyHeight(int ptyHeight) {
        this.config.setPtyHeight(ptyHeight);
    }

    public Map<PtyMode, Integer> getPtyModes() {
        return this.config.getPtyModes();
    }

    public void setPtyModes(Map<PtyMode, Integer> ptyModes) {
        this.config.setPtyModes(ptyModes == null ? Collections.emptyMap() : ptyModes);
    }

    public Object setEnv(String key, Object value) {
        ValidateUtils.checkNotNull((Object)key, (String)"No key provided");
        if (value == null) {
            return this.env.remove(key);
        }
        return this.env.put(key, value);
    }

    public void sendWindowChange(int columns, int lines) throws IOException {
        this.sendWindowChange(columns, lines, this.getPtyHeight(), this.getPtyWidth());
    }

    public void sendWindowChange(int columns, int lines, int height, int width) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWindowChange({}) cols={}, lines={}, height={}, width={}", new Object[]{this, columns, lines, height, width});
        }
        this.setPtyColumns(columns);
        this.setPtyLines(lines);
        this.setPtyHeight(height);
        this.setPtyWidth(width);
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)98, 64);
        buffer.putInt((long)this.getRecipient());
        buffer.putString("window-change");
        buffer.putBoolean(false);
        buffer.putInt((long)this.getPtyColumns());
        buffer.putInt((long)this.getPtyLines());
        buffer.putInt((long)this.getPtyHeight());
        buffer.putInt((long)this.getPtyWidth());
        this.writePacket(buffer);
    }

    protected void doOpenPty() throws IOException {
        Session session = this.getSession();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.agentForwarding) {
            if (debugEnabled) {
                this.log.debug("doOpenPty({}) Send agent forwarding request", (Object)this);
            }
            String channelType = (String)CoreModuleProperties.PROXY_AUTH_CHANNEL_TYPE.getRequired((PropertyResolver)session);
            Buffer buffer = session.createBuffer((byte)98, 64);
            buffer.putInt((long)this.getRecipient());
            buffer.putString(channelType);
            buffer.putBoolean(false);
            this.writePacket(buffer);
        }
        if (this.usePty) {
            if (debugEnabled) {
                this.log.debug("doOpenPty({}) Send SSH_MSG_CHANNEL_REQUEST pty-req: {}", (Object)this, (Object)this.config);
            }
            Buffer buffer = session.createBuffer((byte)98, 127);
            buffer.putInt((long)this.getRecipient());
            buffer.putString("pty-req");
            buffer.putBoolean(false);
            buffer.putString(this.getPtyType());
            buffer.putInt((long)this.getPtyColumns());
            buffer.putInt((long)this.getPtyLines());
            buffer.putInt((long)this.getPtyHeight());
            buffer.putInt((long)this.getPtyWidth());
            Map<PtyMode, Integer> ptyModes = this.getPtyModes();
            int numModes = GenericUtils.size(ptyModes);
            ByteArrayBuffer modes = new ByteArrayBuffer(numModes * 5 + 64, false);
            if (numModes > 0) {
                ptyModes.forEach((arg_0, arg_1) -> PtyCapableChannelSession.lambda$doOpenPty$0((Buffer)modes, arg_0, arg_1));
            }
            modes.putByte((byte)0);
            buffer.putBytes(modes.getCompactData());
            this.writePacket(buffer);
        }
        if (GenericUtils.size(this.env) > 0) {
            if (debugEnabled) {
                this.log.debug("doOpenPty({}) Send SSH_MSG_CHANNEL_REQUEST env: {}", (Object)this, this.env);
            }
            for (Map.Entry<String, Object> entry : this.env.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                String str = Objects.toString(value);
                Buffer buffer = session.createBuffer((byte)98, key.length() + GenericUtils.length((CharSequence)str) + 32);
                buffer.putInt((long)this.getRecipient());
                buffer.putString("env");
                buffer.putBoolean(false);
                buffer.putString(key);
                buffer.putString(str);
                this.writePacket(buffer);
            }
        }
    }

    private static /* synthetic */ void lambda$doOpenPty$0(Buffer modes, PtyMode mode, Integer value) {
        modes.putByte((byte)mode.toInt());
        modes.putInt(value.longValue());
    }
}

