/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.simple;

import java.util.function.Consumer;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.simple.SimpleCache;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;

public class SimpleCacheFactoryServiceConfigurator<K, V extends Identifiable<K>>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
CacheFactory<K, V> {
    private final StatefulComponentDescription componentDescription;
    private final SupplierDependency<ServerEnvironment> environment = new ServiceSupplierDependency(ServerEnvironmentService.SERVICE_NAME);

    public SimpleCacheFactoryServiceConfigurator(ServiceName name, StatefulComponentDescription description) {
        super(name);
        this.componentDescription = description;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer factory = this.environment.register(builder).provides(new ServiceName[]{name});
        Service service = Service.newInstance((Consumer)factory, (Object)this);
        return builder.setInstance(service);
    }

    @Override
    public Cache<K, V> createCache(IdentifierFactory<K> identifierFactory, StatefulObjectFactory<V> factory, PassivationListener<V> passivationListener) {
        StatefulTimeoutInfo timeout = this.componentDescription.getStatefulTimeout();
        return new SimpleCache<K, V>(factory, identifierFactory, this.componentDescription.getStatefulTimeout(), (ServerEnvironment)this.environment.get());
    }
}

