/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.AvailableMechanismsRuntimeResource;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.CommonAttributes;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.RegexAttributeDefinitions;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.AggregateServerMechanismFactory;
import org.wildfly.security.http.util.FilterServerMechanismFactory;
import org.wildfly.security.http.util.PropertiesServerMechanismFactory;
import org.wildfly.security.http.util.SecurityProviderServerMechanismFactory;
import org.wildfly.security.http.util.ServiceLoaderServerMechanismFactory;
import org.wildfly.security.http.util.SetMechanismInformationMechanismFactory;
import org.wildfly.security.http.util.SocketAddressCallbackServerMechanismFactory;
import org.wildfly.security.provider.util.ProviderUtil;

class HttpServerDefinitions {
    static final SimpleAttributeDefinition HTTP_SERVER_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-server-mechanism-factory", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.http-server-mechanism-factory", "org.wildfly.security.http-server-mechanism-factory")).build();
    static final SimpleAttributeDefinition PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("providers", ModelType.STRING, true).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.http-server-mechanism-factory")).build();
    static final SimpleAttributeDefinition PATTERN_FILTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(RegexAttributeDefinitions.PATTERN).setName("pattern-filter")).setXmlName("pattern")).build();
    static final SimpleAttributeDefinition ENABLING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enabling", ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final ObjectTypeAttributeDefinition CONFIGURED_FILTER = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("filter", new AttributeDefinition[]{PATTERN_FILTER, ENABLING}).setXmlName("filter")).build();
    static final ObjectListAttributeDefinition CONFIGURED_FILTERS = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("filters", CONFIGURED_FILTER).setRequired(false)).setRestartAllServices()).setXmlName("filters")).build();
    private static final AggregateComponentDefinition<HttpServerAuthenticationMechanismFactory> AGGREGATE_HTTP_SERVER_FACTORY = AggregateComponentDefinition.create(HttpServerAuthenticationMechanismFactory.class, "aggregate-http-server-mechanism-factory", "http-server-mechanism-factories", Capabilities.HTTP_SERVER_MECHANISM_FACTORY_RUNTIME_CAPABILITY, AggregateServerMechanismFactory::new);

    HttpServerDefinitions() {
    }

    static AggregateComponentDefinition<HttpServerAuthenticationMechanismFactory> getRawAggregateHttpServerFactoryDefinition() {
        return AGGREGATE_HTTP_SERVER_FACTORY;
    }

    static ResourceDefinition getAggregateHttpServerFactoryDefinition() {
        return HttpServerDefinitions.wrapFactory(AGGREGATE_HTTP_SERVER_FACTORY);
    }

    static ResourceDefinition getConfigurableHttpServerMechanismFactoryDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{HTTP_SERVER_FACTORY, CONFIGURED_FILTERS, CommonAttributes.PROPERTIES};
        TrivialAddHandler<HttpServerAuthenticationMechanismFactory> add = new TrivialAddHandler<HttpServerAuthenticationMechanismFactory>(HttpServerAuthenticationMechanismFactory.class, attributes, Capabilities.HTTP_SERVER_MECHANISM_FACTORY_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<HttpServerAuthenticationMechanismFactory> getValueSupplier(ServiceBuilder<HttpServerAuthenticationMechanismFactory> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                Predicate<String> finalFilter;
                InjectedValue factoryInjector = new InjectedValue();
                String httpServerFactory = HTTP_SERVER_FACTORY.resolveModelAttribute(context, model).asString();
                serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.http-server-mechanism-factory", (String)httpServerFactory), HttpServerAuthenticationMechanismFactory.class), HttpServerAuthenticationMechanismFactory.class, (Injector)factoryInjector);
                if (model.hasDefined("filters")) {
                    Predicate<String> filter = null;
                    List nodes = model.require("filters").asList();
                    for (ModelNode current : nodes) {
                        Predicate<String> currentFilter = s -> true;
                        String patternFilter = PATTERN_FILTER.resolveModelAttribute(context, current).asStringOrNull();
                        if (patternFilter != null) {
                            Pattern pattern = Pattern.compile(patternFilter);
                            currentFilter = s -> pattern.matcher((CharSequence)s).find();
                        }
                        currentFilter = ENABLING.resolveModelAttribute(context, current).asBoolean() ? currentFilter : currentFilter.negate();
                        filter = filter == null ? currentFilter : filter.or(currentFilter);
                    }
                    finalFilter = filter;
                } else {
                    finalFilter = null;
                }
                Map propertiesMap = CommonAttributes.PROPERTIES.unwrap((ExpressionResolver)context, model);
                return () -> {
                    HttpServerAuthenticationMechanismFactory factory = (HttpServerAuthenticationMechanismFactory)factoryInjector.getValue();
                    factory = new SocketAddressCallbackServerMechanismFactory(factory);
                    factory = new SetMechanismInformationMechanismFactory(factory);
                    factory = finalFilter != null ? new FilterServerMechanismFactory(factory, finalFilter) : factory;
                    factory = propertiesMap != null ? new PropertiesServerMechanismFactory(factory, propertiesMap) : factory;
                    return factory;
                };
            }
        };
        return HttpServerDefinitions.wrapFactory((ResourceDefinition)new TrivialResourceDefinition("configurable-http-server-mechanism-factory", add, attributes, Capabilities.HTTP_SERVER_MECHANISM_FACTORY_RUNTIME_CAPABILITY));
    }

    static ResourceDefinition getProviderHttpServerMechanismFactoryDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{PROVIDERS};
        TrivialAddHandler<HttpServerAuthenticationMechanismFactory> add = new TrivialAddHandler<HttpServerAuthenticationMechanismFactory>(HttpServerAuthenticationMechanismFactory.class, attributes, Capabilities.HTTP_SERVER_MECHANISM_FACTORY_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<HttpServerAuthenticationMechanismFactory> getValueSupplier(ServiceBuilder<HttpServerAuthenticationMechanismFactory> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                Supplier<Provider[]> providerSupplier;
                String providers = PROVIDERS.resolveModelAttribute(context, model).asStringOrNull();
                if (providers != null) {
                    InjectedValue providersInjector = new InjectedValue();
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)providers), Provider[].class), Provider[].class, (Injector)providersInjector);
                    providerSupplier = () -> ((InjectedValue)providersInjector).getValue();
                } else {
                    providerSupplier = Security::getProviders;
                }
                Predicate<Provider.Service> serviceFilter = s -> HttpServerAuthenticationMechanismFactory.class.getSimpleName().equals(s.getType());
                return () -> {
                    Provider[] actualProviders = (Provider[])providerSupplier.get();
                    if (ProviderUtil.findProviderService((Provider[])actualProviders, (Predicate)serviceFilter) == null) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.noSuitableProvider(HttpServerAuthenticationMechanismFactory.class.getSimpleName());
                    }
                    return new SocketAddressCallbackServerMechanismFactory((HttpServerAuthenticationMechanismFactory)new SetMechanismInformationMechanismFactory((HttpServerAuthenticationMechanismFactory)new SecurityProviderServerMechanismFactory(actualProviders)));
                };
            }
        };
        return HttpServerDefinitions.wrapFactory((ResourceDefinition)new TrivialResourceDefinition("provider-http-server-mechanism-factory", add, attributes, Capabilities.HTTP_SERVER_MECHANISM_FACTORY_RUNTIME_CAPABILITY));
    }

    static ResourceDefinition getServiceLoaderServerMechanismFactoryDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{ClassLoadingAttributeDefinitions.MODULE};
        TrivialAddHandler<HttpServerAuthenticationMechanismFactory> add = new TrivialAddHandler<HttpServerAuthenticationMechanismFactory>(HttpServerAuthenticationMechanismFactory.class, ServiceController.Mode.ACTIVE, ServiceController.Mode.PASSIVE, attributes, Capabilities.HTTP_SERVER_MECHANISM_FACTORY_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<HttpServerAuthenticationMechanismFactory> getValueSupplier(ServiceBuilder<HttpServerAuthenticationMechanismFactory> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String module = ClassLoadingAttributeDefinitions.MODULE.resolveModelAttribute(context, model).asStringOrNull();
                return () -> {
                    try {
                        ClassLoader classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(module));
                        return new SocketAddressCallbackServerMechanismFactory((HttpServerAuthenticationMechanismFactory)new SetMechanismInformationMechanismFactory((HttpServerAuthenticationMechanismFactory)new ServiceLoaderServerMechanismFactory(classLoader)));
                    }
                    catch (Exception e) {
                        throw new StartException((Throwable)e);
                    }
                };
            }
        };
        return HttpServerDefinitions.wrapFactory((ResourceDefinition)new TrivialResourceDefinition("service-loader-http-server-mechanism-factory", add, attributes, Capabilities.HTTP_SERVER_MECHANISM_FACTORY_RUNTIME_CAPABILITY));
    }

    private static ResourceDefinition wrapFactory(ResourceDefinition resourceDefinition) {
        return AvailableMechanismsRuntimeResource.wrap(resourceDefinition, context -> {
            RuntimeCapability runtimeCapability = Capabilities.HTTP_SERVER_MECHANISM_FACTORY_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName httpServerFactoryName = runtimeCapability.getCapabilityServiceName(HttpServerAuthenticationMechanismFactory.class);
            ServiceRegistry registry = context.getServiceRegistry(false);
            ServiceController<HttpServerAuthenticationMechanismFactory> serviceContainer = ElytronExtension.getRequiredService(registry, httpServerFactoryName, HttpServerAuthenticationMechanismFactory.class);
            if (serviceContainer.getState() != ServiceController.State.UP) {
                return null;
            }
            return ((HttpServerAuthenticationMechanismFactory)serviceContainer.getValue()).getMechanismNames(Collections.emptyMap());
        });
    }
}

